/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.SimpleAPI;
import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IExpression;
import ap.parser.IFunApp;
import ap.parser.ITerm;
import ap.terfor.ConstantTerm;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.backends.princess.PrincessEnvironment;
import org.sosy_lab.solver.backends.princess.PrincessTermType;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessModel
extends AbstractModel.CachingAbstractModel<IExpression, PrincessTermType, PrincessEnvironment> {
    private final SimpleAPI.PartialModel model;

    PrincessModel(SimpleAPI.PartialModel partialModel, FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment, ?> creator) {
        super(creator);
        this.model = partialModel;
    }

    @Override
    @Nullable
    public Object evaluateImpl(IExpression f) {
        Option out = this.model.evalExpression(f);
        if (out.isEmpty()) {
            return null;
        }
        SimpleAPI.ModelValue value = (SimpleAPI.ModelValue)out.get();
        return this.getValue(value);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        Map interpretation = this.model.interpretation();
        java.util.Map<IdealInt, ITerm> arrays = this.getArrayAddresses((Map<SimpleAPI.ModelLocation, SimpleAPI.ModelValue>)interpretation);
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Tuple2 entry : interpretation) {
            Model.ValueAssignment assignment = this.getAssignment((SimpleAPI.ModelLocation)entry._1, (SimpleAPI.ModelValue)entry._2, arrays);
            if (assignment == null) continue;
            assignments.add((Object)assignment);
        }
        return assignments.build().asList();
    }

    private java.util.Map<IdealInt, ITerm> getArrayAddresses(Map<SimpleAPI.ModelLocation, SimpleAPI.ModelValue> interpretation) {
        HashMap<IdealInt, ITerm> arrays = new HashMap<IdealInt, ITerm>();
        for (Tuple2 entry : interpretation) {
            if (!(entry._1 instanceof SimpleAPI.ConstantLoc)) continue;
            ITerm maybeArray = ITerm.i((ConstantTerm)((SimpleAPI.ConstantLoc)entry._1).c());
            if (!((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)maybeArray) || !(entry._2 instanceof SimpleAPI.IntValue)) continue;
            arrays.put(((SimpleAPI.IntValue)entry._2).v(), maybeArray);
        }
        return arrays;
    }

    @Nullable
    private Model.ValueAssignment getAssignment(SimpleAPI.ModelLocation key, SimpleAPI.ModelValue value, java.util.Map<IdealInt, ITerm> arrays) {
        Object fValue = this.getValue(value);
        if (key instanceof SimpleAPI.PredicateLoc) {
            Formula fKey = this.creator.encapsulateWithTypeOf(new IAtom(((SimpleAPI.PredicateLoc)key).p(), (Seq)JavaConversions.asScalaBuffer(Collections.emptyList())));
            return new Model.ValueAssignment(fKey, key.toString(), fValue, Collections.emptyList());
        }
        if (key instanceof SimpleAPI.ConstantLoc) {
            ITerm term = ITerm.i((ConstantTerm)((SimpleAPI.ConstantLoc)key).c());
            if (((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)term)) {
                return null;
            }
            return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(term), key.toString(), fValue, Collections.emptyList());
        }
        if (key instanceof SimpleAPI.IntFunctionLoc) {
            SimpleAPI.IntFunctionLoc cKey = (SimpleAPI.IntFunctionLoc)key;
            if ("select/2".equals(cKey.f().toString())) {
                IdealInt arrayId = (IdealInt)cKey.args().apply(0);
                IdealInt arrayIndex = (IdealInt)cKey.args().apply(1);
                ITerm arrayF = arrays.get(arrayId);
                Formula select = this.creator.encapsulateWithTypeOf(((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, ITerm.i((IdealInt)arrayIndex)));
                return new Model.ValueAssignment(select, arrayF.toString(), fValue, Collections.singleton(arrayIndex.bigIntValue()));
            }
            if ("store/3".equals(cKey.f().toString())) {
                IdealInt arrayId = (IdealInt)cKey.args().apply(0);
                assert (arrayId.bigIntValue().equals(fValue));
                IdealInt arrayIndex = (IdealInt)cKey.args().apply(1);
                IdealInt arrayContent = (IdealInt)cKey.args().apply(2);
                ITerm arrayF = arrays.get(arrayId);
                Formula select = this.creator.encapsulateWithTypeOf(((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, ITerm.i((IdealInt)arrayIndex)));
                return new Model.ValueAssignment(select, arrayF.toString(), arrayContent.bigIntValue(), Collections.singleton(arrayIndex.bigIntValue()));
            }
            ArrayList<BigInteger> argumentInterpretation = new ArrayList<BigInteger>();
            ArrayList<ITerm> argTerms = new ArrayList<ITerm>();
            for (IdealInt arg : JavaConversions.seqAsJavaList((Seq)cKey.args())) {
                argumentInterpretation.add(arg.bigIntValue());
                argTerms.add(ITerm.i((IdealInt)arg));
            }
            Formula fKey = this.creator.encapsulateWithTypeOf(new IFunApp(cKey.f(), (Seq)JavaConversions.asScalaBuffer(argTerms)));
            return new Model.ValueAssignment(fKey, cKey.f().name(), fValue, argumentInterpretation);
        }
        throw new AssertionError((Object)String.format("unknown type of key: %s -> %s (%s)", key, value, key.getClass()));
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(SimpleAPI.ModelValue value) {
        if (value instanceof SimpleAPI.BoolValue) {
            return ((SimpleAPI.BoolValue)value).v();
        }
        if (value instanceof SimpleAPI.IntValue) {
            return ((SimpleAPI.IntValue)value).v().bigIntValue();
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }

    @Override
    public void close() {
    }
}

