/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.SimpleAPI;
import ap.parser.IExpression;
import ap.parser.IFormula;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.backends.princess.PrincessAbstractProver;
import org.sosy_lab.solver.backends.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.backends.princess.PrincessFormulaManager;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

class PrincessInterpolatingProver
extends PrincessAbstractProver<Integer, Integer>
implements InterpolatingProverEnvironment<Integer> {
    private final Map<Integer, IFormula> annotatedTerms = new HashMap<Integer, IFormula>();
    private static final UniqueIdGenerator counter = new UniqueIdGenerator();

    PrincessInterpolatingProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier) {
        super(pMgr, creator, pApi, pShutdownNotifier);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        for (Integer removed : (List)this.assertedFormulas.peek()) {
            this.annotatedTerms.remove(removed);
        }
        super.pop();
    }

    @Override
    public Integer addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int termIndex = counter.getFreshId();
        IFormula t = (IFormula)this.mgr.extractInfo(f);
        this.api.setPartitionNumber(termIndex);
        this.addConstraint0(t);
        this.api.setPartitionNumber(-1);
        ((List)this.assertedFormulas.peek()).add(termIndex);
        this.annotatedTerms.put(termIndex, t);
        return termIndex;
    }

    @Override
    public BooleanFormula getInterpolant(List<Integer> pTermNamesOfA) throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        HashSet<Integer> indexesOfA = new HashSet<Integer>(pTermNamesOfA);
        Set indexesOfB = this.annotatedTerms.keySet().stream().filter(f -> !indexesOfA.contains(f)).collect(Collectors.toSet());
        List<BooleanFormula> itp = this.getSeqInterpolants((List<Set<Integer>>)ImmutableList.of(indexesOfA, indexesOfB));
        assert (itp.size() == 1);
        return itp.get(0);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Integer>> partitions) throws SolverException {
        Seq itps;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArrayBuffer args = new ArrayBuffer();
        for (Set<Integer> partition : partitions) {
            args.$plus$eq((Object)JavaConversions.asScalaSet(partition).toSet());
        }
        try {
            itps = this.api.getInterpolants(args.toSeq(), this.api.getInterpolants$default$2());
        }
        catch (StackOverflowError e) {
            throw new SolverException("Princess ran out of stack memory, try increasing the stack size.", e);
        }
        assert (itps.length() == partitions.size() - 1) : "There should be (n-1) interpolants for n partitions";
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (IFormula itp : JavaConversions.seqAsJavaList((Seq)itps)) {
            result.add(this.mgr.encapsulateBooleanFormula((IExpression)itp));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Integer>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("Direct generation of tree interpolants is not supported.\nUse another solver or another strategy for interpolants.");
    }

    @Override
    protected Collection<? extends IExpression> getAssertedFormulas() {
        return this.annotatedTerms.values();
    }
}

