/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.basetypes.IdealInt;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.theories.BitShiftMultiplication;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.backends.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.backends.princess.PrincessNumeralFormulaManager;
import org.sosy_lab.solver.backends.princess.PrincessTermType;

class PrincessIntegerFormulaManager
extends PrincessNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    PrincessIntegerFormulaManager(PrincessFormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected ITerm makeNumberImpl(long i) {
        return new IIntLit(IdealInt.apply((long)i));
    }

    @Override
    protected ITerm makeNumberImpl(BigInteger pI) {
        return new IIntLit(IdealInt.apply((String)pI.toString()));
    }

    @Override
    protected ITerm makeNumberImpl(String pI) {
        return new IIntLit(IdealInt.apply((String)pI));
    }

    @Override
    protected ITerm makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected IExpression makeNumberImpl(BigDecimal pNumber) {
        return (IExpression)this.decimalAsInteger(pNumber);
    }

    @Override
    protected IExpression makeVariableImpl(String varName) {
        PrincessTermType t = (PrincessTermType)((Object)this.getFormulaCreator().getIntegerType());
        return (IExpression)this.getFormulaCreator().makeVariable(t, varName);
    }

    @Override
    protected IExpression modularCongruence(IExpression pNumber1, IExpression pNumber2, long pModulo) {
        if (pModulo > 0L) {
            ITerm n = this.makeNumberImpl(pModulo);
            ITerm x = this.subtract(pNumber1, pNumber2);
            return x.$eq$eq$eq(n.$times(BitShiftMultiplication.eDiv((ITerm)x, (ITerm)n)));
        }
        return new IBoolLit(true);
    }

    @Override
    public IExpression divide(IExpression pNumber1, IExpression pNumber2) {
        return BitShiftMultiplication.eDiv((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
    }

    @Override
    public IExpression modulo(IExpression pNumber1, IExpression pNumber2) {
        return BitShiftMultiplication.eMod((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
    }

    @Override
    public IExpression multiply(IExpression pNumber1, IExpression pNumber2) {
        ITerm result;
        try {
            result = ((ITerm)pNumber1).$times((ITerm)pNumber2);
        }
        catch (IllegalArgumentException e) {
            result = BitShiftMultiplication.mult((ITerm)((ITerm)pNumber1), (ITerm)((ITerm)pNumber2));
        }
        return result;
    }

    @Override
    protected boolean isNumeral(IExpression val) {
        return val instanceof IIntLit;
    }
}

