/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.solver.backends.princess.PrincessEnvironment;
import org.sosy_lab.solver.backends.princess.PrincessTermType;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

abstract class PrincessFunctionDeclaration {
    private PrincessFunctionDeclaration() {
    }

    abstract IExpression makeApp(PrincessEnvironment var1, List<IExpression> var2);

    static class PrincessByExampleDeclaration
    extends PrincessFunctionDeclaration {
        private final IExpression example;

        PrincessByExampleDeclaration(IExpression pExample) {
            this.example = pExample;
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            return this.example.update((Seq)JavaConversions.asScalaBuffer(args));
        }
    }

    static class PrincessIFunctionDeclaration
    extends PrincessFunctionDeclaration {
        private final IFunction app;

        PrincessIFunctionDeclaration(IFunction pApp) {
            this.app = pApp;
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == this.app.arity() ? 1 : 0) != 0, (Object)"functiontype has different number of args.");
            ArrayBuffer argsBuf = new ArrayBuffer();
            for (IExpression arg : args) {
                Object termArg = arg instanceof IFormula ? new ITermITE((IFormula)arg, (ITerm)new IIntLit(IdealInt.ZERO()), (ITerm)new IIntLit(IdealInt.ONE())) : (ITerm)arg;
                argsBuf.$plus$eq(termArg);
            }
            IFunApp returnFormula = new IFunApp(this.app, argsBuf.toSeq());
            PrincessTermType returnType = env.getReturnTypeForFunction(this.app);
            if (returnType == PrincessTermType.Boolean) {
                IExpression.BooleanFunApplier ap = new IExpression.BooleanFunApplier(this.app);
                return ap.apply((Seq)argsBuf);
            }
            if (returnType == PrincessTermType.Integer) {
                return returnFormula;
            }
            throw new AssertionError((Object)"Not possible to have return types for functions other than bool or int.");
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrincessIFunctionDeclaration)) {
                return false;
            }
            PrincessIFunctionDeclaration other = (PrincessIFunctionDeclaration)o;
            return this.app.equals(other.app);
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String toString() {
            return this.app.toString();
        }
    }
}

