/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.ITerm;
import ap.parser.SMTLineariser;
import ap.parser.SMTParser2InputAbsy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.solver.backends.princess.PrincessAbstractProver;
import org.sosy_lab.solver.backends.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.backends.princess.PrincessFormulaManager;
import org.sosy_lab.solver.backends.princess.PrincessInterpolatingProver;
import org.sosy_lab.solver.backends.princess.PrincessSolverContext;
import org.sosy_lab.solver.backends.princess.PrincessTermType;
import org.sosy_lab.solver.backends.princess.PrincessTheoremProver;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessEnvironment {
    private final java.util.Map<String, IFormula> boolVariablesCache = new HashMap<String, IFormula>();
    private final java.util.Map<String, ITerm> intVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, ITerm> arrayVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, IFunction> functionsCache = new HashMap<String, IFunction>();
    private final java.util.Map<IFunction, PrincessTermType> functionsReturnTypes = new HashMap<IFunction, PrincessTermType>();
    @Nullable
    private final PathCounterTemplate basicLogfile;
    private final ShutdownNotifier shutdownNotifier;
    private final SimpleAPI api;
    private final List<PrincessAbstractProver<?, ?>> registeredProvers = new ArrayList();
    private final List<SimpleAPI> reusableAPIs = new ArrayList<SimpleAPI>();
    private final java.util.Map<SimpleAPI, Boolean> allAPIs = new LinkedHashMap<SimpleAPI, Boolean>();
    final PrincessSolverContext.PrincessOptions princessOptions;

    PrincessEnvironment(@Nullable PathCounterTemplate pBasicLogfile, ShutdownNotifier pShutdownNotifier, PrincessSolverContext.PrincessOptions pOptions) {
        this.basicLogfile = pBasicLogfile;
        this.shutdownNotifier = pShutdownNotifier;
        this.api = this.getNewApi(false);
        this.princessOptions = pOptions;
    }

    PrincessAbstractProver<?, ?> getNewProver(boolean useForInterpolation, PrincessFormulaManager mgr, PrincessFormulaCreator creator) {
        SimpleAPI newApi = null;
        if (this.princessOptions.reuseProvers()) {
            Iterator<SimpleAPI> it = this.reusableAPIs.iterator();
            while (it.hasNext()) {
                newApi = it.next();
                if (this.allAPIs.get(newApi) != useForInterpolation) continue;
                it.remove();
                break;
            }
        }
        if (newApi == null) {
            newApi = this.getNewApi(useForInterpolation);
            this.boolVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addBooleanVariable(arg_0));
            this.intVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addConstant(arg_0));
            this.arrayVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addConstant(arg_0));
            this.functionsCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addFunction(arg_0));
            this.allAPIs.put(newApi, useForInterpolation);
        }
        PrincessAbstractProver prover = useForInterpolation ? new PrincessInterpolatingProver(mgr, creator, newApi, this.shutdownNotifier) : new PrincessTheoremProver(mgr, creator, newApi, this.shutdownNotifier);
        this.registeredProvers.add(prover);
        return prover;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private SimpleAPI getNewApi(boolean useForInterpolation) {
        SimpleAPI newApi;
        if (this.basicLogfile != null) {
            Path logPath = this.basicLogfile.getFreshPath();
            String fileName = logPath.getFileName().toString();
            String absPath = logPath.toAbsolutePath().toString();
            File directory = new File(absPath.substring(0, absPath.length() - fileName.length()));
            newApi = SimpleAPI.spawnWithLogNoSanitise((String)fileName, (File)directory);
        } else {
            newApi = SimpleAPI.spawnNoSanitise();
        }
        if (useForInterpolation) {
            newApi.setConstructProofs(true);
        }
        return newApi;
    }

    void unregisterStack(PrincessAbstractProver<?, ?> stack, SimpleAPI usedAPI) {
        assert (this.registeredProvers.contains(stack)) : "cannot unregister stack, it is not registered";
        this.registeredProvers.remove(stack);
        if (this.princessOptions.reuseProvers()) {
            this.reusableAPIs.add(usedAPI);
        } else {
            this.allAPIs.remove(usedAPI);
        }
    }

    void removeStack(PrincessAbstractProver<?, ?> stack, SimpleAPI usedAPI) {
        assert (this.registeredProvers.contains(stack)) : "cannot remove stack, it is not registered";
        this.registeredProvers.remove(stack);
        this.allAPIs.remove(usedAPI);
    }

    public List<? extends IExpression> parseStringToTerms(String s, PrincessFormulaCreator creator) {
        Tuple3 triple = this.api.extractSMTLIBAssertionsSymbols((Reader)new StringReader(s));
        List formula = JavaConversions.seqAsJavaList((Seq)((Seq)triple._1()));
        java.util.Map functionTypes = JavaConversions.mapAsJavaMap((Map)((Map)triple._2()));
        java.util.Map constantTypes = JavaConversions.mapAsJavaMap((Map)((Map)triple._3()));
        HashSet<IExpression> declaredFunctions = new HashSet<IExpression>();
        for (IExpression f : formula) {
            declaredFunctions.addAll(creator.extractVariablesAndUFs(f, true).values());
        }
        for (IExpression var : declaredFunctions) {
            if (var instanceof IConstant) {
                SMTParser2InputAbsy.SMTType type = (SMTParser2InputAbsy.SMTType)constantTypes.get(((IConstant)var).c());
                if (type instanceof SMTParser2InputAbsy.SMTArray) {
                    this.arrayVariablesCache.put(var.toString(), (ITerm)var);
                } else {
                    this.intVariablesCache.put(var.toString(), (ITerm)var);
                }
                this.addSymbol((ITerm)((IConstant)var));
                continue;
            }
            if (var instanceof IAtom) {
                this.boolVariablesCache.put(((IAtom)var).pred().name(), (IFormula)var);
                this.addSymbol((IFormula)((IAtom)var));
                continue;
            }
            if (!(var instanceof IFunApp)) continue;
            IFunction fun = ((IFunApp)var).fun();
            this.functionsCache.put(fun.name(), fun);
            this.functionsReturnTypes.put(fun, PrincessEnvironment.convertToTermType((SMTParser2InputAbsy.SMTFunctionType)functionTypes.get(fun)));
            this.addFunction(fun);
        }
        return formula;
    }

    private static PrincessTermType convertToTermType(SMTParser2InputAbsy.SMTFunctionType type) {
        SMTParser2InputAbsy.SMTType resultType = type.result();
        if (resultType.equals(SMTParser2InputAbsy.SMTBool$.MODULE$)) {
            return PrincessTermType.Boolean;
        }
        return PrincessTermType.Integer;
    }

    public Appender dumpFormula(IFormula formula, final PrincessFormulaCreator creator) {
        Tuple2 tuple = this.api.abbrevSharedExpressionsWithMap((IExpression)formula, 1);
        final IExpression lettedFormula = (IExpression)tuple._1();
        final java.util.Map abbrevMap = JavaConversions.mapAsJavaMap((Map)((Map)tuple._2()));
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                HashSet<IExpression> allVars = new HashSet<IExpression>(creator.extractVariablesAndUFs(lettedFormula, true).values());
                ArrayDeque<IExpression> declaredFunctions = new ArrayDeque<IExpression>(allVars);
                HashSet<String> doneFunctions = new HashSet<String>();
                HashSet<String> todoAbbrevs = new HashSet<String>();
                while (!declaredFunctions.isEmpty()) {
                    IExpression var = (IExpression)declaredFunctions.poll();
                    String name = PrincessEnvironment.getName(var);
                    if (doneFunctions.contains(name)) continue;
                    doneFunctions.add(name);
                    if (name.startsWith("abbrev_")) {
                        todoAbbrevs.add(name);
                        HashSet<IExpression> varsFromAbbrev = new HashSet<IExpression>(creator.extractVariablesAndUFs((IExpression)abbrevMap.get(var), true).values());
                        Sets.difference(varsFromAbbrev, allVars).forEach(declaredFunctions::push);
                        allVars.addAll(varsFromAbbrev);
                        continue;
                    }
                    out.append("(declare-fun ").append(name);
                    out.append(" (");
                    if (var instanceof IFunApp) {
                        IFunApp function = (IFunApp)var;
                        Iterator args = JavaConversions.asJavaIterable((Iterable)function.args()).iterator();
                        while (args.hasNext()) {
                            args.next();
                            if (args.hasNext()) {
                                out.append("Int ");
                                continue;
                            }
                            out.append("Int");
                        }
                    }
                    out.append(") ");
                    out.append(PrincessEnvironment.getType(var));
                    out.append(")\n");
                }
                for (Map.Entry entry : abbrevMap.entrySet()) {
                    IExpression abbrev = (IExpression)entry.getKey();
                    IExpression fullFormula = (IExpression)entry.getValue();
                    String name = PrincessEnvironment.getName((IExpression)Iterables.getOnlyElement(creator.extractVariablesAndUFs(abbrev, true).values()));
                    if (!todoAbbrevs.contains(name)) continue;
                    out.append("(define-fun ").append(name);
                    if (fullFormula instanceof IFormula) {
                        out.append(" () Bool ");
                    } else if (fullFormula instanceof ITerm) {
                        out.append(" () Int ");
                    }
                    out.append(SMTLineariser.asString((IExpression)fullFormula)).append(" )\n");
                }
                out.append("(assert ").append(SMTLineariser.asString((IExpression)lettedFormula)).append(')');
            }
        };
    }

    private static String getName(IExpression var) {
        if (var instanceof IAtom) {
            return ((IAtom)var).pred().name();
        }
        if (var instanceof IConstant) {
            return var.toString();
        }
        if (var instanceof IFunApp) {
            String fullStr = ((IFunApp)var).fun().toString();
            return fullStr.substring(0, fullStr.indexOf(47));
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    private static String getType(IExpression var) {
        if (var instanceof IFormula) {
            return "Bool";
        }
        if (var instanceof ITerm) {
            return "Int";
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    public IExpression makeVariable(PrincessTermType type, String varname) {
        switch (type) {
            case Boolean: {
                if (this.boolVariablesCache.containsKey(varname)) {
                    return (IExpression)this.boolVariablesCache.get(varname);
                }
                IFormula var = this.api.createBooleanVariable(varname);
                this.addSymbol(var);
                this.boolVariablesCache.put(varname, var);
                return var;
            }
            case Integer: {
                if (this.intVariablesCache.containsKey(varname)) {
                    return (IExpression)this.intVariablesCache.get(varname);
                }
                ITerm var = this.api.createConstant(varname);
                this.addSymbol(var);
                this.intVariablesCache.put(varname, var);
                return var;
            }
            case Array: {
                if (this.arrayVariablesCache.containsKey(varname)) {
                    return (IExpression)this.arrayVariablesCache.get(varname);
                }
                ITerm var = this.api.createConstant(varname);
                this.addSymbol(var);
                this.arrayVariablesCache.put(varname, var);
                return var;
            }
        }
        throw new AssertionError((Object)("unsupported type: " + (Object)((Object)type)));
    }

    public IFunction declareFun(String name, int nofArgs, PrincessTermType returnType) {
        if (this.functionsCache.containsKey(name)) {
            assert (returnType == this.functionsReturnTypes.get(this.functionsCache.get(name)));
            return this.functionsCache.get(name);
        }
        IFunction funcDecl = this.api.createFunction(name, nofArgs);
        this.addFunction(funcDecl);
        this.functionsCache.put(name, funcDecl);
        this.functionsReturnTypes.put(funcDecl, returnType);
        return funcDecl;
    }

    PrincessTermType getReturnTypeForFunction(IFunction fun) {
        return this.functionsReturnTypes.get(fun);
    }

    public ITerm makeSelect(ITerm array, ITerm index) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index);
        return this.api.select(JavaConversions.iterableAsScalaIterable((java.lang.Iterable)args).toSeq());
    }

    public ITerm makeStore(ITerm array, ITerm index, ITerm value) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index, (Object)value);
        return this.api.store(JavaConversions.iterableAsScalaIterable((java.lang.Iterable)args).toSeq());
    }

    public boolean hasArrayType(IExpression exp) {
        return this.arrayVariablesCache.containsValue(exp) || exp instanceof IFunApp && ((IFunApp)exp).fun().toString().equals("store/3");
    }

    public IFormula elimQuantifiers(IFormula formula) {
        return this.api.simplify(formula);
    }

    public String getVersion() {
        return "Princess (unknown version)";
    }

    private void addSymbol(IFormula symbol) {
        for (SimpleAPI simpleAPI : this.allAPIs.keySet()) {
            simpleAPI.addBooleanVariable(symbol);
        }
        for (PrincessAbstractProver princessAbstractProver : this.registeredProvers) {
            princessAbstractProver.addSymbol(symbol);
        }
    }

    private void addSymbol(ITerm symbol) {
        for (SimpleAPI simpleAPI : this.allAPIs.keySet()) {
            simpleAPI.addConstant(symbol);
        }
        for (PrincessAbstractProver princessAbstractProver : this.registeredProvers) {
            princessAbstractProver.addSymbol(symbol);
        }
    }

    private void addFunction(IFunction funcDecl) {
        for (SimpleAPI simpleAPI : this.allAPIs.keySet()) {
            simpleAPI.addFunction(funcDecl);
        }
        for (PrincessAbstractProver princessAbstractProver : this.registeredProvers) {
            princessAbstractProver.addSymbol(funcDecl);
        }
    }
}

