/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.SimpleAPI;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.ITerm;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.backends.princess.PrincessEnvironment;
import org.sosy_lab.solver.backends.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.backends.princess.PrincessFormulaManager;
import org.sosy_lab.solver.backends.princess.PrincessModel;
import scala.Enumeration;
import scala.collection.JavaConversions;

abstract class PrincessAbstractProver<E, AF>
implements BasicProverEnvironment<E> {
    protected final SimpleAPI api;
    protected final PrincessFormulaManager mgr;
    protected final Deque<List<AF>> assertedFormulas = new ArrayDeque<List<AF>>();
    private final Deque<Level> trackingStack = new ArrayDeque<Level>();
    protected final ShutdownNotifier shutdownNotifier;
    protected final PrincessFormulaCreator creator;
    protected boolean closed = false;
    protected boolean wasLastSatCheckSat = false;

    protected PrincessAbstractProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier) {
        this.mgr = pMgr;
        this.creator = creator;
        this.api = (SimpleAPI)Preconditions.checkNotNull((Object)pApi);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
    }

    @Override
    public boolean isUnsat() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        Enumeration.Value result = this.api.checkSat(true);
        if (result == SimpleAPI.ProverStatus$.MODULE$.Sat()) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (result == SimpleAPI.ProverStatus$.MODULE$.Unsat()) {
            return true;
        }
        if (result == SimpleAPI.ProverStatus$.MODULE$.OutOfMemory()) {
            throw new SolverException("Princess ran out of stack or heap memory, try increasing their sizes.");
        }
        throw new SolverException("Princess' checkSat call returned " + result);
    }

    protected void addConstraint0(IFormula t) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.api.addAssertion(this.api.abbrevSharedExpressions(t, ((PrincessEnvironment)this.creator.getEnv()).princessOptions.getMinAtomsForAbbreviation()));
    }

    @Override
    public final void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.assertedFormulas.push(new ArrayList());
        this.api.push();
        this.trackingStack.push(new Level());
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.assertedFormulas.pop();
        this.api.pop();
        Level level = this.trackingStack.pop();
        this.api.addBooleanVariables(JavaConversions.iterableAsScalaIterable(level.booleanSymbols));
        this.api.addConstants(JavaConversions.iterableAsScalaIterable(level.intSymbols));
        level.functionSymbols.forEach(arg_0 -> ((SimpleAPI)this.api).addFunction(arg_0));
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().mergeWithHigher(level);
        }
    }

    @Override
    public PrincessModel getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"model is only available for SAT environments");
        return new PrincessModel(this.api.partialModel(), this.creator);
    }

    protected abstract Collection<? extends IExpression> getAssertedFormulas();

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        try (PrincessModel model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Assumption-solving is not supported.");
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.api);
        Preconditions.checkNotNull((Object)this.mgr);
        if (!this.closed) {
            if (this.shutdownNotifier.shouldShutdown()) {
                ((PrincessEnvironment)this.creator.getEnv()).removeStack(this, this.api);
                this.api.shutDown();
            } else {
                for (int i = 0; i < this.trackingStack.size(); ++i) {
                    this.pop();
                }
                ((PrincessEnvironment)this.creator.getEnv()).unregisterStack(this, this.api);
            }
        }
        this.closed = true;
    }

    void addSymbol(IFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().booleanSymbols.add(f);
        }
    }

    void addSymbol(ITerm f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().intSymbols.add(f);
        }
    }

    void addSymbol(IFunction f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().functionSymbols.add(f);
        }
    }

    private static class Level {
        List<IFormula> booleanSymbols = new ArrayList<IFormula>();
        List<ITerm> intSymbols = new ArrayList<ITerm>();
        List<IFunction> functionSymbols = new ArrayList<IFunction>();

        private Level() {
        }

        void mergeWithHigher(Level other) {
            this.booleanSymbols.addAll(other.booleanSymbols);
            this.intSymbols.addAll(other.intSymbols);
            this.functionSymbols.addAll(other.functionSymbols);
        }
    }
}

