/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.mathsat5;

import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.basicimpl.AbstractUFManager;

class Mathsat5UFManager
extends AbstractUFManager<Long, Long, Long, Long> {
    private final long mathsatEnv;

    Mathsat5UFManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    public long createUIFCallImpl(long funcDecl, long[] args) {
        return Mathsat5NativeApi.msat_make_uf(this.mathsatEnv, funcDecl, args);
    }

    @Override
    protected Long createUninterpretedFunctionCallImpl(Long funcDecl, List<Long> pArgs) {
        long[] args = Longs.toArray(pArgs);
        return this.createUIFCallImpl(funcDecl, args);
    }

    @Override
    protected Long declareUninterpretedFunctionImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long[] types = Longs.toArray(pArgTypes);
        return this.createFunctionImpl(pName, returnType, types);
    }

    public long createFunctionImpl(String pName, long returnType, long[] msatTypes) {
        long msatFuncType = Mathsat5NativeApi.msat_get_function_type(this.mathsatEnv, msatTypes, msatTypes.length, returnType);
        long decl = Mathsat5NativeApi.msat_declare_function(this.mathsatEnv, pName, msatFuncType);
        return decl;
    }
}

