/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.mathsat5;

import java.math.BigDecimal;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5IntegerFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Mathsat5IntegerFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return (Long)this.decimalAsInteger(pNumber);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        String[] frac;
        if (!this.isNumeral(pNumber2)) {
            return super.divide(pNumber1, pNumber2);
        }
        long mathsatEnv = (Long)this.getFormulaCreator().getEnv();
        long t1 = pNumber1;
        long t2 = pNumber2;
        String n = Mathsat5NativeApi.msat_term_repr(t2);
        if (n.startsWith("(")) {
            n = n.substring(1, n.length() - 1);
        }
        if ((frac = n.split("/")).length == 1) {
            return super.divide(pNumber1, pNumber2);
        }
        assert (frac.length == 2);
        n = frac[1] + "/" + frac[0];
        t2 = Mathsat5NativeApi.msat_make_number(mathsatEnv, n);
        return Mathsat5NativeApi.msat_make_times(mathsatEnv, t2, t1);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        if (pModulo > 0L) {
            return Mathsat5NativeApi.msat_make_int_modular_congruence((Long)this.getFormulaCreator().getEnv(), pModulo, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_true((Long)this.getFormulaCreator().getEnv());
    }
}

