/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.mathsat5;

import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5NativeApi;

abstract class Mathsat5Formula
implements Formula {
    private final long msatTerm;

    Mathsat5Formula(long term) {
        this.msatTerm = term;
    }

    public final String toString() {
        return Mathsat5NativeApi.msat_term_repr(this.msatTerm);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mathsat5Formula)) {
            return false;
        }
        return this.msatTerm == ((Mathsat5Formula)o).msatTerm;
    }

    public final int hashCode() {
        return (int)this.msatTerm;
    }

    final long getTerm() {
        return this.msatTerm;
    }

    static final class Mathsat5BooleanFormula
    extends Mathsat5Formula
    implements BooleanFormula {
        Mathsat5BooleanFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5RationalFormula
    extends Mathsat5Formula
    implements NumeralFormula.RationalFormula {
        Mathsat5RationalFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5IntegerFormula
    extends Mathsat5Formula
    implements NumeralFormula.IntegerFormula {
        Mathsat5IntegerFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5FloatingPointRoundingModeFormula
    extends Mathsat5Formula
    implements FloatingPointRoundingModeFormula {
        Mathsat5FloatingPointRoundingModeFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5FloatingPointFormula
    extends Mathsat5Formula
    implements FloatingPointFormula {
        Mathsat5FloatingPointFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5BitvectorFormula
    extends Mathsat5Formula
    implements BitvectorFormula {
        Mathsat5BitvectorFormula(long pTerm) {
            super(pTerm);
        }
    }

    static final class Mathsat5ArrayFormula<TI extends Formula, TE extends Formula>
    extends Mathsat5Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        Mathsat5ArrayFormula(long pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pTerm);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

