/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5Model;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.backends.mathsat5.Mathsat5SolverContext;

abstract class Mathsat5AbstractProver<T2>
implements BasicProverEnvironment<T2> {
    protected final Mathsat5SolverContext context;
    protected final long curEnv;
    private final long curConfig;
    private final long terminationTest;
    protected final Mathsat5FormulaCreator creator;
    protected boolean closed = false;

    protected Mathsat5AbstractProver(Mathsat5SolverContext pContext, Map<String, String> pConfig, Mathsat5FormulaCreator creator) {
        this.context = pContext;
        this.creator = creator;
        this.curConfig = this.buildConfig(pConfig);
        this.curEnv = this.context.createEnvironment(this.curConfig);
        this.terminationTest = this.context.addTerminationTest(this.curEnv);
    }

    private long buildConfig(Map<String, String> pConfig) {
        long cfg = Mathsat5NativeApi.msat_create_config();
        for (Map.Entry<String, String> entry : pConfig.entrySet()) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, entry.getKey(), entry.getValue());
        }
        return cfg;
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            return !Mathsat5NativeApi.msat_check_sat(this.curEnv);
        }
        catch (IllegalStateException e) {
            this.handleSolverExceptionInUnsatCheck(e);
            throw e;
        }
    }

    protected void handleSolverExceptionInUnsatCheck(IllegalStateException e) throws SolverException {
        String msg = Strings.nullToEmpty((String)e.getMessage());
        if (msg.contains("too many iterations") || msg.contains("impossible to build a suitable congruence graph!") || msg.contains("can't produce proofs") || msg.contains("FP<->BV combination unsupported by the current configuration") || msg.equals("msat_solve returned \"unknown\": unsupported")) {
            throw new SolverException(e.getMessage(), e);
        }
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Mathsat5Model.create(this.creator, this.curEnv);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        try (Mathsat5Model model = Mathsat5Model.create(this.creator, this.curEnv);){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_destroy_env(this.curEnv);
        Mathsat5NativeApi.msat_free_termination_test(this.terminationTest);
        Mathsat5NativeApi.msat_destroy_config(this.curConfig);
        this.closed = true;
    }
}

