/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.common.ChildFirstPatternClassLoader;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.logging.LoggingSolverContext;
import org.sosy_lab.solver.mathsat5.Mathsat5SolverContext;
import org.sosy_lab.solver.princess.PrincessSolverContext;

@Options(prefix="solver")
public class SolverContextFactory {
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    private boolean logAllQueries = false;
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    @Nullable
    private PathCounterTemplate logfile = PathCounterTemplate.ofFormatString((String)"smtquery.%03d.smt2");
    @Option(secure=true, description="Random seed for SMT solver.")
    private long randomSeed = 42L;
    @Option(secure=true, description="Which SMT solver to use.")
    private Solvers solver = Solvers.SMTINTERPOL;
    @Option(secure=true, name="useLogger", description="Log solver actions, this may be slow!")
    private boolean useLogger = false;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private static final String solverPathPrefix = "org.sosy_lab.solver";
    private static final Pattern SMTINTERPOL_CLASSES = Pattern.compile("^(" + Pattern.quote("org.sosy_lab.solver") + "\\.smtinterpol|" + "de\\.uni_freiburg\\.informatik\\.ultimate|" + "java_cup\\.runtime|" + "org\\.apache\\.log4j" + ")\\..*");
    private static final String SMTINTERPOL_CLASS = "de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol";
    private static final String SMTINTERPOL_FACTORY_CLASS = "org.sosy_lab.solver.smtinterpol.SmtInterpolSolverFactory";
    private static final String Z3_FACTORY_CLASS = "org.sosy_lab.solver.z3.Z3LoadingFactory";
    private static final Pattern Z3_CLASSES = Pattern.compile("^(com\\.microsoft\\.z3|" + Pattern.quote("org.sosy_lab.solver") + "\\.z3" + ")\\..*");
    private static final Set<String> expectedLibrariesToLoad = ImmutableSet.of((Object)"z3", (Object)"libz3", (Object)"libz3java", (Object)"z3java");
    private static final ClassLoader z3ClassLoader = SolverContextFactory.createZ3ClassLoader();
    private static WeakReference<ClassLoader> smtInterpolClassLoader = new WeakReference<Object>(null);
    private static final AtomicInteger smtInterpolLoadingCount = new AtomicInteger(0);

    public SolverContextFactory(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger.withComponentName("JavaSMT");
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.config = pConfig;
        if (!this.logAllQueries) {
            this.logfile = null;
        }
    }

    public SolverContext generateContext() throws InvalidConfigurationException {
        return this.generateContext(this.solver);
    }

    public SolverContext generateContext(Solvers solverToCreate) throws InvalidConfigurationException {
        SolverContext context;
        try {
            context = this.generateContext0(solverToCreate);
        }
        catch (UnsatisfiedLinkError e) {
            throw new InvalidConfigurationException(String.format("The SMT solver %s is not available on this machine because of missing libraries (%s). You may experiment with SMTInterpol by setting solver.solver=SMTInterpol.", new Object[]{solverToCreate, e.getMessage()}), (Throwable)e);
        }
        if (this.useLogger) {
            context = new LoggingSolverContext(this.logger, context);
        }
        return context;
    }

    private SolverContext generateContext0(Solvers solverToCreate) throws InvalidConfigurationException {
        switch (solverToCreate) {
            case SMTINTERPOL: {
                return this.getFactoryForSolver(SolverContextFactory.createSmtInterpolClassLoader(this.logger), SMTINTERPOL_FACTORY_CLASS).create(this.config, this.logger, this.shutdownNotifier, this.logfile, this.randomSeed);
            }
            case MATHSAT5: {
                return Mathsat5SolverContext.create(this.logger, this.config, this.shutdownNotifier, this.logfile, this.randomSeed);
            }
            case Z3: {
                return this.getFactoryForSolver(z3ClassLoader, Z3_FACTORY_CLASS).create(this.config, this.logger, this.shutdownNotifier, this.logfile, this.randomSeed);
            }
            case PRINCESS: {
                return PrincessSolverContext.create(this.config, this.shutdownNotifier, this.logfile);
            }
        }
        throw new AssertionError((Object)"no solver selected");
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext();
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier, Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext(solver);
    }

    public static SolverContext createSolverContext(Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(Configuration.defaultConfiguration(), LogManager.createNullLogManager(), ShutdownNotifier.createDummy()).generateContext(solver);
    }

    private InnerUtilFactory getFactoryForSolver(ClassLoader pClassLoader, String factoryClassName) {
        try {
            Class<?> factoryClass = pClassLoader.loadClass(factoryClassName);
            Constructor<?> factoryConstructor = factoryClass.getConstructor(new Class[0]);
            return (InnerUtilFactory)factoryConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to load" + factoryClassName, (Throwable)e);
        }
    }

    private static ClassLoader createZ3ClassLoader() {
        URL[] urls;
        ClassLoader parentClassLoader = SolverContextFactory.class.getClassLoader();
        if (parentClassLoader instanceof URLClassLoader) {
            URLClassLoader uParentClassLoader = (URLClassLoader)parentClassLoader;
            urls = uParentClassLoader.getURLs();
        } else {
            urls = new URL[]{SolverContextFactory.class.getProtectionDomain().getCodeSource().getLocation()};
        }
        return new CustomLibraryPathClassLoader(Z3_CLASSES, urls, parentClassLoader);
    }

    private static ClassLoader createSmtInterpolClassLoader(LogManager logger) {
        String classFile;
        URL url;
        ClassLoader classLoader = (ClassLoader)smtInterpolClassLoader.get();
        if (classLoader != null) {
            return classLoader;
        }
        if (smtInterpolLoadingCount.incrementAndGet() > 1) {
            logger.log(Level.INFO, new Object[]{"Repeated loading of SmtInterpol"});
        }
        if ((url = (classLoader = SolverContextFactory.class.getClassLoader()).getResource(classFile = SMTINTERPOL_CLASS.replace('.', File.separatorChar) + ".class")) != null && url.getProtocol().equals("jar") && url.getFile().contains("!")) {
            try {
                url = new URL(url.getFile().substring(0, url.getFile().lastIndexOf(33)));
                URL[] urls = new URL[]{url, SolverContextFactory.class.getProtectionDomain().getCodeSource().getLocation()};
                classLoader = new ChildFirstPatternClassLoader(SMTINTERPOL_CLASSES, urls, classLoader);
            }
            catch (MalformedURLException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Could not create proper classpath for SMTInterpol, loading correct java-cup classes may fail.");
            }
        } else {
            logger.log(Level.WARNING, new Object[]{"Could not create proper classpath for SMTInterpol because location of SMTInterpol classes is unexpected, loading correct java-cup classes may fail. Location of SMTInterpol is ", url});
        }
        smtInterpolClassLoader = new WeakReference<ClassLoader>(classLoader);
        return classLoader;
    }

    private static class CustomLibraryPathClassLoader
    extends ChildFirstPatternClassLoader {
        CustomLibraryPathClassLoader(Pattern pClassPattern, URL[] pUrls, ClassLoader pParent) {
            super(pClassPattern, pUrls, pParent);
        }

        protected String findLibrary(String libname) {
            Optional path;
            if (expectedLibrariesToLoad.contains(libname) && (path = NativeLibraries.findPathForLibrary((String)libname)).isPresent()) {
                return ((Path)path.get()).toAbsolutePath().toString();
            }
            return super.findLibrary(libname);
        }
    }

    public static abstract class InnerUtilFactory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SolverContext create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed) throws InvalidConfigurationException {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.getClass().getClassLoader());
                SolverContext solverContext = this.generateSolverContext(config, logger, pShutdownNotifier, solverLogfile, randomSeed);
                return solverContext;
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }

        protected abstract SolverContext generateSolverContext(Configuration var1, LogManager var2, ShutdownNotifier var3, @Nullable PathCounterTemplate var4, long var5) throws InvalidConfigurationException;
    }

    @VisibleForTesting
    public static enum Solvers {
        MATHSAT5,
        SMTINTERPOL,
        Z3,
        PRINCESS;

    }
}

