
package org.sosy_lab.solver.basicimpl.cache;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.annotation.Generated;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.OptimizationProverEnvironment.OptStatus;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_OptimizationResult extends OptimizationResult {

  private final OptStatus result;
  private final ImmutableMap<Integer, Optional<Rational>> objectiveValues;
  private final Optional<CachedModel> model;

  AutoValue_OptimizationResult(
      OptStatus result,
      ImmutableMap<Integer, Optional<Rational>> objectiveValues,
      Optional<CachedModel> model) {
    if (result == null) {
      throw new NullPointerException("Null result");
    }
    this.result = result;
    if (objectiveValues == null) {
      throw new NullPointerException("Null objectiveValues");
    }
    this.objectiveValues = objectiveValues;
    if (model == null) {
      throw new NullPointerException("Null model");
    }
    this.model = model;
  }

  @Override
  public OptStatus result() {
    return result;
  }

  @Override
  public ImmutableMap<Integer, Optional<Rational>> objectiveValues() {
    return objectiveValues;
  }

  @Override
  public Optional<CachedModel> model() {
    return model;
  }

  @Override
  public String toString() {
    return "OptimizationResult{"
        + "result=" + result + ", "
        + "objectiveValues=" + objectiveValues + ", "
        + "model=" + model
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OptimizationResult) {
      OptimizationResult that = (OptimizationResult) o;
      return (this.result.equals(that.result()))
           && (this.objectiveValues.equals(that.objectiveValues()))
           && (this.model.equals(that.model()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.result.hashCode();
    h *= 1000003;
    h ^= this.objectiveValues.hashCode();
    h *= 1000003;
    h ^= this.model.hashCode();
    return h;
  }

}
