/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Params;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.z3java.Z3AbstractProver;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3FormulaManager;
import org.sosy_lab.solver.z3java.Z3Model;

class Z3TheoremProver
extends Z3AbstractProver<Void>
implements ProverEnvironment {
    private final Solver z3solver;
    private int level = 0;
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    private final FormulaManager mgr;
    private static final String UNSAT_CORE_TEMP_VARNAME = "UNSAT_CORE_%d";
    @Nullable
    private final Map<String, BooleanFormula> storedConstraints;

    Z3TheoremProver(Z3FormulaCreator creator, Z3FormulaManager pMgr, Params z3params, ShutdownNotifier pShutdownNotifier, SolverContext.ProverOptions ... options) {
        super(creator, pShutdownNotifier);
        this.mgr = pMgr;
        this.z3solver = this.z3context.mkSolver();
        this.z3solver.setParameters(z3params);
        HashSet opts = Sets.newHashSet((Object[])options);
        this.storedConstraints = opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) ? new HashMap<String, BooleanFormula>() : null;
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((this.z3solver.getNumScopes() >= 1 ? 1 : 0) != 0);
        --this.level;
        this.z3solver.pop();
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.trackConstraint(f);
        BoolExpr e = (BoolExpr)this.creator.extractInfo(f);
        if (this.storedConstraints != null) {
            String varName = String.format(UNSAT_CORE_TEMP_VARNAME, this.trackId.getFreshId());
            BooleanFormula t = this.mgr.getBooleanFormulaManager().makeVariable(varName);
            this.z3solver.assertAndTrack(e, (BoolExpr)this.creator.extractInfo(t));
            this.storedConstraints.put(varName, f);
        } else {
            this.z3solver.add(new BoolExpr[]{e});
        }
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        this.z3solver.push();
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Status result = this.z3solver.check();
        this.shutdownNotifier.shutdownIfNecessary();
        Preconditions.checkArgument((result != Status.UNKNOWN ? 1 : 0) != 0);
        return result == Status.UNSATISFIABLE;
    }

    @Override
    protected com.microsoft.z3.Model getZ3Model() {
        return this.z3solver.getModel();
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return new Z3Model(this.getZ3Model(), this.creator, ((Z3AbstractProver)this).storedConstraints);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        BoolExpr[] unsatCore;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (BoolExpr ast : unsatCore = this.z3solver.getUnsatCore()) {
            String varName = ast.toString();
            constraints.add(this.storedConstraints.get(varName));
        }
        return constraints;
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((this.z3solver.getNumScopes() >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
        while (this.level > 0) {
            this.pop();
        }
        this.closed = true;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            BoolExpr[] importantFormulas = new BoolExpr[important.size()];
            int i = 0;
            for (BooleanFormula impF : important) {
                importantFormulas[i++] = (BoolExpr)this.creator.extractInfo(impF);
            }
            this.z3solver.push();
            while (this.z3solver.check() == Status.SATISFIABLE) {
                BoolExpr[] valuesOfModel = new BoolExpr[importantFormulas.length];
                com.microsoft.z3.Model z3model = this.z3solver.getModel();
                for (int j = 0; j < importantFormulas.length; ++j) {
                    BoolExpr valueOfExpr = (BoolExpr)z3model.getConstInterp((Expr)importantFormulas[j]);
                    valuesOfModel[j] = valueOfExpr.isFalse() ? this.z3context.mkNot(importantFormulas[j]) : importantFormulas[j];
                }
                callback.apply(Lists.transform(Arrays.asList(valuesOfModel), (Function)this.creator.encapsulateBoolean));
                BoolExpr negatedModel = this.z3context.mkNot(this.z3context.mkAnd(valuesOfModel));
                this.z3solver.add(new BoolExpr[]{negatedModel});
            }
            this.z3solver.pop();
            return callback.getResult();
        }
        catch (Z3Exception e) {
            this.shutdownNotifier.shutdownIfNecessary();
            throw new SolverException("Z3 had a problem during ALLSAT computation", e);
        }
    }
}

