/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Model;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.Params;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.z3java.Z3AbstractProver;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3NumeralFormulaManager;

class Z3OptimizationProver
extends Z3AbstractProver<Void>
implements OptimizationProverEnvironment {
    private final FormulaManager mgr;
    private final RationalFormulaManager rfmgr;
    private final LogManager logger;
    private static final String Z3_INFINITY_REPRESENTATION = "oo";
    private final Optimize z3optContext;
    private final List<Optimize.Handle> handles = new ArrayList<Optimize.Handle>();

    Z3OptimizationProver(FormulaManager mgr, Z3FormulaCreator creator, ShutdownNotifier pShutdownNotifier, LogManager pLogger) {
        super(creator, pShutdownNotifier);
        this.mgr = mgr;
        this.rfmgr = mgr.getRationalFormulaManager();
        this.z3optContext = this.z3context.mkOptimize();
        this.logger = pLogger;
    }

    private int putToMap(Optimize.Handle handle) {
        int key = this.handles.size();
        this.handles.add(handle);
        return key;
    }

    private Optimize.Handle getFromMap(int index) {
        return this.handles.get(index);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.trackConstraint(constraint);
        BoolExpr z3Constraint = (BoolExpr)this.creator.extractInfo(constraint);
        this.z3optContext.Add(new BoolExpr[]{z3Constraint});
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Optimize.Handle handle = this.z3optContext.MkMaximize(Z3NumeralFormulaManager.toAE(this.creator.extractInfo(objective)));
        return this.putToMap(handle);
    }

    @Override
    public int minimize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Optimize.Handle handle = this.z3optContext.MkMinimize(Z3NumeralFormulaManager.toAE(this.creator.extractInfo(objective)));
        return this.putToMap(handle);
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Status status = this.z3optContext.Check();
        if (status == Status.UNSATISFIABLE) {
            return OptimizationProverEnvironment.OptStatus.UNSAT;
        }
        if (status == Status.UNKNOWN) {
            this.logger.log(Level.INFO, new Object[]{"Solver returned an unknown status, explanation: ", this.z3optContext.getReasonUnknown()});
            return OptimizationProverEnvironment.OptStatus.UNDEF;
        }
        return OptimizationProverEnvironment.OptStatus.OPT;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.z3optContext.Push();
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.z3optContext.Pop();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.check() == OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArithExpr ast = this.getFromMap(handle).getUpper();
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArithExpr ast = this.getFromMap(handle).getLower();
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    protected Model getZ3Model() {
        return this.z3optContext.getModel();
    }

    void setParam(String key, String value) {
        Params params = this.z3context.mkParams();
        params.add(key, value);
        this.z3optContext.setParameters(params);
    }

    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.z3optContext.toString();
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
    }

    private boolean isInfinity(ArithExpr pAst) {
        return pAst.toString().contains(Z3_INFINITY_REPRESENTATION);
    }

    private Expr replaceEpsilon(ArithExpr pAst, Rational newValue) {
        NumeralFormula z;
        if (pAst instanceof IntNum) {
            z = this.creator.encapsulate(FormulaType.IntegerType, pAst);
        } else if (pAst instanceof RatNum) {
            z = this.creator.encapsulate(FormulaType.RationalType, pAst);
        } else {
            throw new AssertionError((Object)String.format("unexpected type of expression %s (%s)", pAst, pAst.getClass()));
        }
        NumeralFormula.RationalFormula epsFormula = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("epsilon");
        NumeralFormula.IntegerFormula out = this.mgr.substitute(z, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of((Object)epsFormula, this.rfmgr.makeNumber(newValue.toString())));
        return this.creator.extractInfo(out).simplify();
    }

    private Rational rationalFromZ3AST(Expr ast) {
        return Rational.ofString((String)ast.toString());
    }
}

