/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Expr;
import com.microsoft.z3.InterpolationContext;
import com.microsoft.z3.Model;
import com.microsoft.z3.Params;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.z3java.Z3AbstractProver;
import org.sosy_lab.solver.z3java.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

class Z3InterpolatingProver
extends Z3AbstractProver<Expr>
implements InterpolatingProverEnvironment<Expr> {
    private final Solver z3solver;
    private int level = 0;
    private final Deque<BoolExpr> assertedFormulas = new ArrayDeque<BoolExpr>();

    Z3InterpolatingProver(Z3FormulaCreator creator, Params z3params, ShutdownNotifier pShutdownNotifier) {
        super(creator, pShutdownNotifier);
        this.z3solver = this.z3context.mkSolver();
        this.z3solver.setParameters(z3params);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((this.z3solver.getNumScopes() >= 1 ? 1 : 0) != 0);
        --this.level;
        this.assertedFormulas.removeLast();
        this.z3solver.pop();
    }

    @Override
    public Expr addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.trackConstraint(f);
        BoolExpr e = (BoolExpr)this.creator.extractInfo(f);
        this.z3solver.add(new BoolExpr[]{e});
        this.assertedFormulas.addLast(e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        this.z3solver.push();
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Status result = this.z3solver.check();
        this.shutdownNotifier.shutdownIfNecessary();
        Preconditions.checkArgument((result != Status.UNKNOWN ? 1 : 0) != 0);
        return result == Status.UNSATISFIABLE;
    }

    @Override
    public BooleanFormula getInterpolant(List<Expr> formulasOfA) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LinkedList formulasOfB = Lists.newLinkedList(this.assertedFormulas);
        for (Expr af : formulasOfA) {
            boolean check = formulasOfB.remove(af);
            assert (check) : "formula from A must be part of all asserted formulas";
        }
        return (BooleanFormula)Iterables.getOnlyElement(this.getSeqInterpolants((List<Set<Expr>>)ImmutableList.of((Object)Sets.newHashSet(formulasOfA), (Object)Sets.newHashSet((Iterable)formulasOfB))));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Expr>> partitionedFormulas) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionedFormulas.size() >= 2 ? 1 : 0) != 0, (Object)"at least 2 partitions needed for interpolation");
        return this.getTreeInterpolants(partitionedFormulas, new int[partitionedFormulas.size()]);
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Expr>> partitionedFormulas, int[] startOfSubTree) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            BoolExpr[] conjunctionFormulas = new BoolExpr[partitionedFormulas.size()];
            for (int i = 0; i < partitionedFormulas.size(); ++i) {
                BoolExpr conjunction;
                Preconditions.checkState((!partitionedFormulas.get(i).isEmpty() ? 1 : 0) != 0);
                conjunctionFormulas[i] = conjunction = this.z3context.mkAnd(Z3BooleanFormulaManager.toBool((Collection<? extends Expr>)partitionedFormulas.get(i)));
            }
            ArrayDeque<Z3TreeInterpolant> stack = new ArrayDeque<Z3TreeInterpolant>();
            int lastSubtree = -1;
            for (int i = 0; i < startOfSubTree.length; ++i) {
                BoolExpr interpolationPoint;
                BoolExpr conjunction;
                int currentSubtree = startOfSubTree[i];
                if (currentSubtree > lastSubtree) {
                    conjunction = conjunctionFormulas[i];
                } else {
                    ArrayList<BoolExpr> children = new ArrayList<BoolExpr>();
                    while (!stack.isEmpty() && currentSubtree <= ((Z3TreeInterpolant)stack.peekLast()).getRootOfTree()) {
                        children.add(0, ((Z3TreeInterpolant)stack.pollLast()).getInterpolationPoint());
                    }
                    children.add(conjunctionFormulas[i]);
                    conjunction = this.z3context.mkAnd(Z3BooleanFormulaManager.toBool(children));
                }
                if (i == startOfSubTree.length - 1) {
                    interpolationPoint = conjunction;
                    Preconditions.checkState((currentSubtree == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
                    Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should be the last element in the stack.");
                } else {
                    interpolationPoint = ((InterpolationContext)this.z3context).MkInterpolant(conjunction);
                }
                stack.addLast(new Z3TreeInterpolant(currentSubtree, interpolationPoint));
                lastSubtree = currentSubtree;
            }
            Preconditions.checkState((((Z3TreeInterpolant)stack.peekLast()).getRootOfTree() == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
            BoolExpr root = ((Z3TreeInterpolant)stack.pollLast()).getInterpolationPoint();
            Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should have been the last element in the stack.");
            Expr proof = this.z3solver.getProof();
            BoolExpr[] interpolationResult = ((InterpolationContext)this.z3context).GetInterpolant(proof, (Expr)root, this.z3context.mkParams());
            this.shutdownNotifier.shutdownIfNecessary();
            ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
            for (int i = 0; i < partitionedFormulas.size() - 1; ++i) {
                result.add(this.creator.encapsulateBoolean(interpolationResult[i]));
            }
            return result;
        }
        catch (Z3Exception e) {
            this.shutdownNotifier.shutdownIfNecessary();
            throw new SolverException("Z3 had a problem during interpolation computation", e);
        }
    }

    @Override
    protected Model getZ3Model() {
        return this.z3solver.getModel();
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        while (this.level > 0) {
            this.pop();
        }
        this.assertedFormulas.clear();
        this.closed = true;
    }

    private static class Z3TreeInterpolant {
        private final int rootOfSubTree;
        private final BoolExpr interpolationPoint;

        private Z3TreeInterpolant(int pRootOfSubtree, BoolExpr pInterpolationPoint) {
            this.rootOfSubTree = pRootOfSubtree;
            this.interpolationPoint = pInterpolationPoint;
        }

        private int getRootOfTree() {
            return this.rootOfSubTree;
        }

        private BoolExpr getInterpolationPoint() {
            return this.interpolationPoint;
        }
    }
}

