/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiHelpers;

class Z3QuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3QuantifiedFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long exists(List<Long> pVariables, Long pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.EXISTS, pVariables, pBody);
    }

    @Override
    protected Long forall(List<Long> pVariables, Long pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.FORALL, pVariables, pBody);
    }

    @Override
    public Long mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<Long> pVariables, Long pBody) {
        return Z3NativeApi.mk_quantifier_const(this.z3context, q == QuantifiedFormulaManager.Quantifier.FORALL, 0, pVariables.size(), Longs.toArray(pVariables), 0, new long[0], pBody);
    }

    @Override
    protected Long eliminateQuantifiers(Long pExtractInfo) throws SolverException, InterruptedException {
        return Z3NativeApiHelpers.applyTactics(this.z3context, pExtractInfo, "qe-light", "qe");
    }
}

