/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.z3.Z3ArrayFormulaManager;
import org.sosy_lab.solver.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.solver.z3.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3.Z3Formula;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3IntegerFormulaManager;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;
import org.sosy_lab.solver.z3.Z3NativeApiHelpers;
import org.sosy_lab.solver.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.solver.z3.Z3RationalFormulaManager;
import org.sosy_lab.solver.z3.Z3SolverContext;
import org.sosy_lab.solver.z3.Z3UFManager;

final class Z3FormulaManager
extends AbstractFormulaManager<Long, Long, Long, Long> {
    private static final ImmutableMap<Tactic, String> Z3_TACTICS = ImmutableMap.builder().put((Object)Tactic.NNF, (Object)"nnf").put((Object)Tactic.CNF, (Object)"cnf").put((Object)Tactic.TSEITIN_CNF, (Object)"tseitin-cnf").put((Object)Tactic.QE, (Object)"qe").put((Object)Tactic.QE_LIGHT, (Object)"qe-light").build();

    Z3FormulaManager(Z3FormulaCreator pFormulaCreator, Z3UFManager pFunctionManager, Z3BooleanFormulaManager pBooleanManager, Z3IntegerFormulaManager pIntegerManager, Z3RationalFormulaManager pRationalManager, Z3BitvectorFormulaManager pBitpreciseManager, Z3QuantifiedFormulaManager pQuantifiedManager, Z3ArrayFormulaManager pArrayManager) {
        super(pFormulaCreator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, null, pQuantifiedManager, pArrayManager);
    }

    @Override
    public BooleanFormula parse(String str) throws IllegalArgumentException {
        long[] sortSymbols = new long[]{};
        long[] sorts = new long[]{};
        long[] declSymbols = new long[]{};
        long[] decls = new long[]{};
        long e = Z3NativeApi.parse_smtlib2_string((Long)this.getEnvironment(), str, sortSymbols, sorts, declSymbols, decls);
        return this.getFormulaCreator().encapsulateBoolean(e);
    }

    static long getZ3Expr(Formula pT) {
        if (pT instanceof Z3Formula) {
            return ((Z3Formula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    @Override
    protected Long applyTacticImpl(Long input, Tactic tactic) throws InterruptedException {
        String z3TacticName = (String)Z3_TACTICS.get((Object)tactic);
        if (z3TacticName != null) {
            return Z3NativeApiHelpers.applyTactic((Long)this.getFormulaCreator().getEnv(), input, z3TacticName);
        }
        return super.applyTacticImpl(input, tactic);
    }

    @Override
    public Appender dumpFormula(final Long expr) {
        assert (this.getFormulaCreator().getFormulaType(expr) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                long z3solver = Z3NativeApi.mk_solver((Long)Z3FormulaManager.this.getEnvironment());
                Z3NativeApi.solver_inc_ref((Long)Z3FormulaManager.this.getEnvironment(), z3solver);
                Z3NativeApi.solver_assert((Long)Z3FormulaManager.this.getEnvironment(), z3solver, expr);
                String serialized = Z3NativeApi.solver_to_string((Long)Z3FormulaManager.this.getEnvironment(), z3solver);
                Z3NativeApi.solver_dec_ref((Long)Z3FormulaManager.this.getEnvironment(), z3solver);
                out.append(serialized);
            }
        };
    }

    @Override
    protected Long simplify(Long pF) {
        return Z3NativeApi.simplify((Long)this.getFormulaCreator().getEnv(), pF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<? extends Long> splitNumeralEqualityIfPossible(Long pF) {
        long z3context = (Long)this.getFormulaCreator().getEnv();
        if (Z3NativeApiConstants.isOP(z3context, pF, 258) && Z3NativeApi.get_app_num_args(z3context, pF) == 2) {
            long arg0 = Z3NativeApi.get_app_arg(z3context, pF, 0);
            Z3NativeApi.inc_ref(z3context, arg0);
            long arg1 = Z3NativeApi.get_app_arg(z3context, pF, 1);
            Z3NativeApi.inc_ref(z3context, arg1);
            try {
                long sortKind = Z3NativeApi.get_sort_kind(z3context, Z3NativeApi.get_sort(z3context, arg0));
                assert (sortKind == (long)Z3NativeApi.get_sort_kind(z3context, Z3NativeApi.get_sort(z3context, arg1)));
                if (sortKind == 4L) {
                    long out1 = Z3NativeApi.mk_bvule(z3context, arg0, arg1);
                    Z3NativeApi.inc_ref(z3context, out1);
                    long out2 = Z3NativeApi.mk_bvuge(z3context, arg0, arg1);
                    Z3NativeApi.inc_ref(z3context, out2);
                    ImmutableList immutableList = ImmutableList.of((Object)out1, (Object)out2);
                    return immutableList;
                }
                if (sortKind == 2L || sortKind == 3L) {
                    long out1 = Z3NativeApi.mk_le(z3context, arg0, arg1);
                    Z3NativeApi.inc_ref(z3context, out1);
                    long out2 = Z3NativeApi.mk_ge(z3context, arg0, arg1);
                    Z3NativeApi.inc_ref(z3context, out2);
                    ImmutableList immutableList = ImmutableList.of((Object)out1, (Object)out2);
                    return immutableList;
                }
            }
            finally {
                Z3NativeApi.dec_ref(z3context, arg0);
                Z3NativeApi.dec_ref(z3context, arg1);
            }
        }
        return ImmutableList.of((Object)pF);
    }

    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.substituteUsingLists(pF, pFromToMapping);
    }

    @Override
    protected Long substituteUsingListsImpl(Long t, List<Long> changeFrom, List<Long> changeTo) {
        int size = changeFrom.size();
        Preconditions.checkState((size == changeTo.size() ? 1 : 0) != 0);
        return Z3NativeApi.substitute((Long)this.getFormulaCreator().getEnv(), t, size, Longs.toArray(changeFrom), Longs.toArray(changeTo));
    }

    @Override
    public BooleanFormula translate(BooleanFormula other, SolverContext otherContext) {
        if (otherContext instanceof Z3SolverContext) {
            Z3SolverContext o = (Z3SolverContext)otherContext;
            long otherZ3Context = (Long)o.getFormulaManager().getEnvironment();
            if (otherZ3Context == (Long)this.getEnvironment()) {
                return other;
            }
            long translatedAST = Z3NativeApi.translate(otherZ3Context, (Long)this.extractInfo(other), (Long)this.getEnvironment());
            return this.getFormulaCreator().encapsulateBoolean(translatedAST);
        }
        return super.translate(other, otherContext);
    }
}

