/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import javax.annotation.Nullable;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.z3.Z3NativeApi;

abstract class Z3Formula
implements Formula {
    private final long z3expr;
    private final long z3context;
    private int hashCache = 0;

    private Z3Formula(long z3context, long z3expr) {
        this.z3expr = z3expr;
        this.z3context = z3context;
        Z3NativeApi.inc_ref(z3context, z3expr);
    }

    public final String toString() {
        return Z3NativeApi.ast_to_string(this.z3context, this.z3expr);
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof Z3Formula)) {
            return false;
        }
        Z3Formula other = (Z3Formula)obj;
        return this.z3context == other.z3context && Z3NativeApi.is_eq_ast(this.z3context, this.z3expr, other.z3expr);
    }

    public final int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Z3NativeApi.get_ast_hash(this.z3context, this.z3expr);
        }
        return this.hashCache;
    }

    final long getFormulaInfo() {
        return this.z3expr;
    }

    static final class Z3BooleanFormula
    extends Z3Formula
    implements BooleanFormula {
        Z3BooleanFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3RationalFormula
    extends Z3Formula
    implements NumeralFormula.RationalFormula {
        Z3RationalFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3IntegerFormula
    extends Z3Formula
    implements NumeralFormula.IntegerFormula {
        Z3IntegerFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3BitvectorFormula
    extends Z3Formula
    implements BitvectorFormula {
        Z3BitvectorFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3ArrayFormula<TI extends Formula, TE extends Formula>
    extends Z3Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        Z3ArrayFormula(long pZ3context, long pZ3expr, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pZ3context, pZ3expr);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

