/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.primitives.Longs;
import java.util.Collection;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;

class Z3BooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3BooleanFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long makeBooleanImpl(boolean pValue) {
        if (pValue) {
            return Z3NativeApi.mk_true(this.z3context);
        }
        return Z3NativeApi.mk_false(this.z3context);
    }

    @Override
    protected Long not(Long pParam) {
        return Z3NativeApi.mk_not(this.z3context, pParam);
    }

    @Override
    protected Long and(Long pParam1, Long pParam2) {
        return Z3NativeApi.mk_and(this.z3context, pParam1, pParam2);
    }

    @Override
    protected Long or(Long pParam1, Long pParam2) {
        return Z3NativeApi.mk_or(this.z3context, pParam1, pParam2);
    }

    @Override
    protected Long orImpl(Collection<Long> params) {
        return Z3NativeApi.mk_or(this.z3context, params.size(), Longs.toArray(params));
    }

    @Override
    protected Long andImpl(Collection<Long> params) {
        return Z3NativeApi.mk_and(this.z3context, params.size(), Longs.toArray(params));
    }

    @Override
    protected Long xor(Long pParam1, Long pParam2) {
        return Z3NativeApi.mk_xor(this.z3context, pParam1, pParam2);
    }

    @Override
    protected Long equivalence(Long pBits1, Long pBits2) {
        return Z3NativeApi.mk_eq(this.z3context, pBits1, pBits2);
    }

    @Override
    protected Long implication(Long pBits1, Long pBits2) {
        return Z3NativeApi.mk_implies(this.z3context, pBits1, pBits2);
    }

    @Override
    protected boolean isTrue(Long pParam) {
        return Z3NativeApiConstants.isOP(this.z3context, pParam, 256);
    }

    @Override
    protected boolean isFalse(Long pParam) {
        return Z3NativeApiConstants.isOP(this.z3context, pParam, 257);
    }

    @Override
    protected Long ifThenElse(Long pCond, Long pF1, Long pF2) {
        return Z3NativeApi.mk_ite(this.z3context, pCond, pF1, pF2);
    }
}

