/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;

class Z3ArrayFormulaManager
extends AbstractArrayFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3ArrayFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long select(Long pArray, Long pIndex) {
        try {
            long term = Z3NativeApi.mk_select(this.z3context, pArray, pIndex);
            Z3NativeApi.inc_ref(this.z3context, term);
            return term;
        }
        catch (IllegalArgumentException ae) {
            int errorCode = Z3NativeApi.get_error_code(this.z3context);
            throw new IllegalArgumentException(String.format("Errorcode: %d, msg: %s", errorCode, Z3NativeApi.get_error_msg_ex(this.z3context, errorCode)));
        }
    }

    @Override
    protected Long store(Long pArray, Long pIndex, Long pValue) {
        long term = Z3NativeApi.mk_store(this.z3context, pArray, pIndex, pValue);
        Z3NativeApi.inc_ref(this.z3context, term);
        return term;
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Long internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Long z3ArrayType = (Long)this.toSolverType(arrayFormulaType);
        long arrayTerm = (Long)this.getFormulaCreator().makeVariable(z3ArrayType, pName);
        Z3NativeApi.inc_ref(this.z3context, arrayTerm);
        return arrayTerm;
    }

    @Override
    protected Long equivalence(Long pArray1, Long pArray2) {
        long term = Z3NativeApi.mk_eq(this.z3context, pArray1, pArray2);
        Z3NativeApi.inc_ref(this.z3context, term);
        return term;
    }
}

