/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;
import org.sosy_lab.solver.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

@RunWith(value=Parameterized.class)
public class SolverVisitorTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void booleanIdVisit() {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        BooleanFormula f = this.bmgr.makeBoolean(false);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        BooleanFormula z = this.bmgr.makeVariable("z");
        BooleanFormula and = this.bmgr.and(x, y);
        BooleanFormula or = this.bmgr.or(x, y);
        BooleanFormula ite = this.bmgr.ifThenElse(x, and, or);
        BooleanFormula impl = this.bmgr.implication(z, y);
        BooleanFormula eq = this.bmgr.equivalence(t, y);
        BooleanFormula not = this.bmgr.not(eq);
        for (BooleanFormula bf : Lists.newArrayList((Object[])new BooleanFormula[]{t, f, x, y, z, and, or, ite, impl, eq, not})) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr, new HashMap()){};
            this.assertThatFormula(this.bmgr.visit(identityVisitor, bf)).isEqualTo(bf);
        }
    }

    @Test
    public void booleanIdVisitWithAtoms() {
        NumeralFormula.IntegerFormula n12 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(12L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula sum = (NumeralFormula.IntegerFormula)this.imgr.add(a, b);
        NumeralFormula.IntegerFormula diff = (NumeralFormula.IntegerFormula)this.imgr.subtract(a, b);
        NumeralFormula.IntegerFormula neg = (NumeralFormula.IntegerFormula)this.imgr.negate(a);
        BooleanFormula eq = this.imgr.equal(n12, a);
        NumeralFormula.IntegerFormula ite = this.bmgr.ifThenElse(eq, sum, diff);
        for (NumeralFormula.IntegerFormula f : Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{a, b, n12, neg, ite})) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr, new HashMap()){};
            BooleanFormula bf = this.imgr.equal(n12, f);
            this.assertThatFormula(this.bmgr.visit(identityVisitor, bf)).isEqualTo(bf);
        }
    }

    @Test
    public void testFormulaVisitor() {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
        BooleanFormula f = this.bmgr.or(this.imgr.equal(z, this.imgr.add(x, y)), this.imgr.equal(x, this.imgr.add(z, y)));
        final HashSet usedVariables = new HashSet();
        DefaultFormulaVisitor<TraversalProcess> nameExtractor = new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                usedVariables.add(name);
                return TraversalProcess.CONTINUE;
            }
        };
        this.mgr.visitRecursively((FormulaVisitor<TraversalProcess>)nameExtractor, f);
        Truth.assertThat(usedVariables).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"x", "y", "z"}));
    }

    @Test
    public void testBooleanFormulaQuantifierHandling() throws Exception {
        this.requireQuantifiers();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        assert (this.qmgr != null);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula constraint = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)x), x);
        this.assertThatFormula(constraint).isUnsatisfiable();
        BooleanFormula newConstraint = this.bmgr.visit(new BooleanFormulaTransformationVisitor(this.mgr, new HashMap()){}, constraint);
        this.assertThatFormula(newConstraint).isUnsatisfiable();
    }

    @Test
    public void testVisitingTrue() throws Exception {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        final ArrayList containsTrue = new ArrayList();
        this.mgr.visitRecursively((FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitConstant(Formula f, Object o) {
                if (f.equals(SolverVisitorTest.this.bmgr.makeBoolean(true))) {
                    containsTrue.add(true);
                }
                return TraversalProcess.CONTINUE;
            }
        }, t);
        Truth.assertThat(containsTrue).isNotEmpty();
    }

    @Test
    public void testCorrectFunctionNames() throws Exception {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula ab = this.bmgr.and(a, b);
        final HashSet found = new HashSet();
        this.mgr.visitRecursively((FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                found.add(functionDeclaration.getName());
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                found.add(name);
                return TraversalProcess.CONTINUE;
            }
        }, ab);
        Truth.assertThat(found).hasSize(3);
        Truth.assertThat(found).doesNotContain((Object)ab.toString());
    }

    @Test
    public void recursiveTransformationVisitorTest() throws Exception {
        BooleanFormula f = this.bmgr.or(this.imgr.equal(this.imgr.add(this.imgr.makeVariable("x"), this.imgr.makeVariable("y")), this.imgr.makeNumber(1L)), this.imgr.equal(this.imgr.makeVariable("z"), this.imgr.makeNumber(10L)));
        BooleanFormula transformed = this.mgr.transformRecursively(new FormulaTransformationVisitor(this.mgr){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return SolverVisitorTest.this.mgr.makeVariable(SolverVisitorTest.this.mgr.getFormulaType(f), name + "'");
            }
        }, f);
        this.assertThatFormula(transformed).isEquivalentTo(this.bmgr.or(this.imgr.equal(this.imgr.add(this.imgr.makeVariable("x'"), this.imgr.makeVariable("y'")), this.imgr.makeNumber(1L)), this.imgr.equal(this.imgr.makeVariable("z'"), this.imgr.makeNumber(10L))));
    }

    @Test
    public void booleanRecursiveTraversalTest() throws Exception {
        BooleanFormula f = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("x"), this.bmgr.makeVariable("y")), this.bmgr.and((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.makeVariable("z"), (Object)this.bmgr.makeVariable("d"), (Object)this.imgr.equal(this.imgr.makeVariable("gg"), this.imgr.makeNumber(5L)))));
        final HashSet foundVars = new HashSet();
        this.bmgr.visitRecursively((BooleanFormulaVisitor<TraversalProcess>)new DefaultBooleanFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault() {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> funcDecl) {
                if (funcDecl.getKind() == FunctionDeclarationKind.VAR) {
                    foundVars.add(funcDecl.getName());
                }
                return TraversalProcess.CONTINUE;
            }
        }, f);
        Truth.assertThat(foundVars).containsExactly(new Object[]{"x", "y", "z", "d"});
    }
}

