/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.test.SolverBasedTest0;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;

@RunWith(value=Parameterized.class)
public class SolverTacticsTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Test
    public void nnfTacticDefaultTest1() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula not_a_b = this.bmgr.not(this.bmgr.equivalence(a, b));
        BooleanFormula nnf = this.mgr.applyTactic(not_a_b, Tactic.NNF);
        this.assertThatFormula(nnf).isEquivalentTo(not_a_b);
        NNFChecker checker = new NNFChecker(this.mgr);
        this.bmgr.visit(checker, nnf);
        Truth.assertThat((Boolean)checker.isInNNF()).isTrue();
    }

    @Test
    public void nnfTacticDefaultTest2() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        BooleanFormula not_ITE_a_b_c = this.bmgr.not(this.bmgr.ifThenElse(a, b, c));
        BooleanFormula nnf = this.mgr.applyTactic(not_ITE_a_b_c, Tactic.NNF);
        this.assertThatFormula(nnf).isEquivalentTo(not_ITE_a_b_c);
        NNFChecker checker = new NNFChecker(this.mgr);
        checker.visit(nnf);
        Truth.assertThat((Boolean)checker.isInNNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest1() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula equiv_a_b = this.bmgr.equivalence(a, b);
        BooleanFormula not_equiv_a_b = this.bmgr.not(equiv_a_b);
        BooleanFormula cnf_equiv_a_b = this.mgr.applyTactic(equiv_a_b, Tactic.CNF);
        this.assertThatFormula(cnf_equiv_a_b).isEquivalentTo(equiv_a_b);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf_equiv_a_b);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
        BooleanFormula cnf_not_equiv_a_b = this.mgr.applyTactic(not_equiv_a_b, Tactic.CNF);
        this.assertThatFormula(cnf_not_equiv_a_b).isEquivalentTo(not_equiv_a_b);
        checker = new CNFChecker(this.mgr);
        checker.visit(cnf_not_equiv_a_b);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest2() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        BooleanFormula ITE_a_b_c = this.bmgr.ifThenElse(a, b, c);
        BooleanFormula not_ITE_a_b_c = this.bmgr.not(this.bmgr.ifThenElse(a, b, c));
        BooleanFormula cnf_ITE_a_b_c = this.mgr.applyTactic(ITE_a_b_c, Tactic.CNF);
        this.assertThatFormula(cnf_ITE_a_b_c).isEquivalentTo(ITE_a_b_c);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf_ITE_a_b_c);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
        BooleanFormula cnf_not_ITE_a_b_c = this.mgr.applyTactic(not_ITE_a_b_c, Tactic.CNF);
        this.assertThatFormula(cnf_not_ITE_a_b_c).isEquivalentTo(not_ITE_a_b_c);
        checker = new CNFChecker(this.mgr);
        checker.visit(cnf_not_ITE_a_b_c);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest3() throws SolverException, InterruptedException {
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        BooleanFormula z = this.bmgr.makeVariable("z");
        BooleanFormula w = this.bmgr.makeVariable("w");
        BooleanFormula u = this.bmgr.makeVariable("u");
        BooleanFormula v = this.bmgr.makeVariable("v");
        ArrayList<BooleanFormula> disjuncts = new ArrayList<BooleanFormula>();
        disjuncts.add(this.bmgr.and(x, y));
        disjuncts.add(this.bmgr.and(z, w));
        disjuncts.add(this.bmgr.and(u, v));
        BooleanFormula f = this.bmgr.or(disjuncts);
        BooleanFormula cnf = this.mgr.applyTactic(f, Tactic.CNF);
        this.assertThatFormula(cnf).isEquivalentTo(f);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    private static class NNFChecker
    implements BooleanFormulaVisitor<Void> {
        private final BooleanFormulaManager bfmgr;
        boolean wasLastVisitNot = false;
        boolean notOnlyAtAtoms = true;

        protected NNFChecker(FormulaManager pFmgr) {
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        Void visit(BooleanFormula f) {
            return this.bfmgr.visit(this, f);
        }

        public boolean isInNNF() {
            return this.notOnlyAtAtoms;
        }

        @Override
        public Void visitConstant(boolean value) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitBoundVar(BooleanFormula var, int deBruijnIdx) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitNot(BooleanFormula pOperand) {
            this.wasLastVisitNot = true;
            return this.visit(pOperand);
        }

        @Override
        public Void visitAnd(List<BooleanFormula> pOperands) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                for (BooleanFormula op : pOperands) {
                    this.visit(op);
                }
            }
            return null;
        }

        @Override
        public Void visitOr(List<BooleanFormula> pOperands) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                for (BooleanFormula op : pOperands) {
                    this.visit(op);
                }
            }
            return null;
        }

        @Override
        public Void visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            return null;
        }

        @Override
        public Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pCondition);
                this.visit(pThenFormula);
                this.visit(pElseFormula);
            }
            return null;
        }

        @Override
        public Void visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifierAST, List<Formula> boundVars, BooleanFormula pBody) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pBody);
            }
            return null;
        }
    }

    private static class CNFChecker
    implements BooleanFormulaVisitor<Void> {
        private final BooleanFormulaManager bfmgr;
        boolean startsWithAnd = false;
        boolean containsMoreAnd = false;
        boolean started = false;

        protected CNFChecker(FormulaManager pFmgr) {
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        Void visit(BooleanFormula f) {
            return this.bfmgr.visit(this, f);
        }

        public boolean isInCNF() {
            return this.startsWithAnd && !this.containsMoreAnd || this.started && !this.startsWithAnd;
        }

        @Override
        public Void visitConstant(boolean value) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitBoundVar(BooleanFormula f, int deBruijnIdx) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitNot(BooleanFormula pOperand) {
            this.started = true;
            return this.visit(pOperand);
        }

        @Override
        public Void visitAnd(List<BooleanFormula> pOperands) {
            if (!this.started) {
                this.started = true;
                this.startsWithAnd = true;
            } else {
                this.containsMoreAnd = true;
            }
            for (BooleanFormula op : pOperands) {
                this.visit(op);
            }
            return null;
        }

        @Override
        public Void visitOr(List<BooleanFormula> pOperands) {
            if (this.started) {
                for (BooleanFormula op : pOperands) {
                    this.visit(op);
                }
            }
            return null;
        }

        @Override
        public Void visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.started) {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.started) {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            if (this.started) {
                this.visit(pCondition);
                this.visit(pThenFormula);
                this.visit(pElseFormula);
            }
            return null;
        }

        @Override
        public Void visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifierAST, List<Formula> boundVars, BooleanFormula pBody) {
            if (this.started) {
                this.visit(pBody);
            }
            return null;
        }
    }
}

