/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverAllSatTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private ProverEnvironment env;
    private static final String EXPECTED_RESULT = "AllSatTest_unsat";

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setupEnvironment() {
        this.env = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);
    }

    @After
    public void closeEnvironment() {
        this.env.close();
    }

    @Test
    public void allSatTest_unsat() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula n1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula n2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula cond1 = this.imgr.equal(a, n1);
        BooleanFormula cond2 = this.imgr.equal(a, n2);
        BooleanFormula v1 = this.bmgr.makeVariable("b1");
        BooleanFormula v2 = this.bmgr.makeVariable("b2");
        this.env.push(cond1);
        this.env.push(cond2);
        this.env.push(this.bmgr.equivalence(v1, cond1));
        this.env.push(this.bmgr.equivalence(v2, cond2));
        TestAllSatCallback callback = new TestAllSatCallback(){

            @Override
            public void apply(List<BooleanFormula> pModel) {
                Assert.fail((String)("Formula is unsat, but all-sat callback called with model " + pModel));
            }
        };
        Truth.assertThat((String)this.env.allSat(callback, (List<BooleanFormula>)ImmutableList.of((Object)v1, (Object)v2))).isEqualTo((Object)EXPECTED_RESULT);
    }

    @Test
    public void allSatTest_xor() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula n1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula n2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula cond1 = this.imgr.equal(a, n1);
        BooleanFormula cond2 = this.imgr.equal(a, n2);
        BooleanFormula v1 = this.bmgr.makeVariable("b1");
        BooleanFormula v2 = this.bmgr.makeVariable("b2");
        this.env.push(this.bmgr.xor(cond1, cond2));
        this.env.push(this.bmgr.equivalence(v1, cond1));
        this.env.push(this.bmgr.equivalence(v2, cond2));
        TestAllSatCallback callback = new TestAllSatCallback();
        Truth.assertThat((String)this.env.allSat(callback, (List<BooleanFormula>)ImmutableList.of((Object)v1, (Object)v2))).isEqualTo((Object)EXPECTED_RESULT);
        Truth.assertThat((Iterable)callback.models).containsExactly(new Object[]{ImmutableList.of((Object)v1, (Object)this.bmgr.not(v2)), ImmutableList.of((Object)this.bmgr.not(v1), (Object)v2)});
    }

    private static class TestAllSatCallback
    implements ProverEnvironment.AllSatCallback<String> {
        private final List<List<BooleanFormula>> models = new ArrayList<List<BooleanFormula>>();

        private TestAllSatCallback() {
        }

        @Override
        public void apply(List<BooleanFormula> pModel) {
            this.models.add((List<BooleanFormula>)ImmutableList.copyOf(pModel));
        }

        @Override
        public String getResult() throws InterruptedException {
            return SolverAllSatTest.EXPECTED_RESULT;
        }
    }
}

