/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class OptimizationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() {
        return super.createTestConfigBuilder().setOption("solver.mathsat5.loadOptimathsat5", "true");
    }

    @Before
    public void skipUnsupportedSolvers() throws Exception {
        this.requireOptimization();
    }

    @Test
    public void testUnbounded() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment();){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("obj");
            ImmutableList constraints = ImmutableList.of((Object)this.rmgr.greaterOrEquals(x, this.rmgr.makeNumber("10")), (Object)this.rmgr.equal(x, obj));
            prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)constraints));
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth.assertThat(prover.upper(handle, Rational.ZERO)).isAbsent();
        }
    }

    @Test
    public void testUnfeasible() throws Exception {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment();){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("y");
            ImmutableList constraints = ImmutableList.of((Object)this.rmgr.lessThan(x, y), (Object)this.rmgr.greaterThan(x, y));
            prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)constraints));
            prover.maximize(x);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.UNSAT);
        }
    }

    @Test
    public void testOptimal() throws Exception {
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula obj = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("obj");
            ImmutableList constraints = ImmutableList.of((Object)this.imgr.lessOrEquals(x, this.imgr.makeNumber(10L)), (Object)this.imgr.lessOrEquals(y, this.imgr.makeNumber(15L)), (Object)this.imgr.equal(obj, this.imgr.add(x, y)), (Object)this.imgr.greaterOrEquals(this.imgr.subtract(x, y), this.imgr.makeNumber(1L)));
            prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)constraints));
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"19"));
            Model model = prover.getModel();
            BigInteger xValue = model.evaluate(x);
            BigInteger objValue = model.evaluate(obj);
            BigInteger yValue = model.evaluate(y);
            Truth.assertThat((Comparable)objValue).isEqualTo((Object)BigInteger.valueOf(19L));
            Truth.assertThat((Comparable)xValue).isEqualTo((Object)BigInteger.valueOf(10L));
            Truth.assertThat((Comparable)yValue).isEqualTo((Object)BigInteger.valueOf(9L));
        }
    }

    @Test
    public void testSwitchingObjectives() throws Exception {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment();){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("y");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("obj");
            prover.push();
            ImmutableList constraints = ImmutableList.of((Object)this.rmgr.lessOrEquals(x, this.rmgr.makeNumber(10L)), (Object)this.rmgr.lessOrEquals(y, this.rmgr.makeNumber(15L)), (Object)this.rmgr.equal(obj, this.rmgr.add(x, y)), (Object)this.rmgr.greaterOrEquals(this.rmgr.subtract(x, y), this.rmgr.makeNumber(1L)));
            prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)constraints));
            prover.push();
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"19"));
            prover.pop();
            prover.push();
            handle = prover.maximize(x);
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"10"));
            prover.pop();
            prover.push();
            handle = prover.maximize((Formula)this.rmgr.makeVariable("y"));
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"9"));
            prover.pop();
        }
    }
}

