/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;

class SmtInterpolUtil {
    private SmtInterpolUtil() {
    }

    public static String prettyPrint(Term t) {
        StringBuilder str = new StringBuilder();
        SmtInterpolUtil.prettyPrint(t, str, 0);
        return str.toString();
    }

    private static void prettyPrint(Term t, StringBuilder str, int n) {
        for (int i = 0; i < n; ++i) {
            str.append("  ");
        }
        if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            String function = at.getFunction().getName();
            if ("and".equals(function) || "or".equals(function)) {
                str.append("(").append(function).append("\n");
                for (Term child : at.getParameters()) {
                    SmtInterpolUtil.prettyPrint(child, str, n + 1);
                }
                for (int i = 0; i < n; ++i) {
                    str.append("  ");
                }
                str.append(")\n");
            } else {
                str.append(t.toStringDirect()).append("\n");
            }
        } else {
            str.append(t.toStringDirect()).append("\n");
        }
    }
}

