/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.TermExtractionModelIterator;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolModel
extends AbstractModel<Term, Sort, SmtInterpolEnvironment> {
    private final Model model;
    private final ImmutableList<Term> assertedTerms;
    private final SmtInterpolFormulaCreator formulaCreator;

    SmtInterpolModel(Model pModel, FormulaCreator<Term, Sort, SmtInterpolEnvironment, ?> pCreator, Collection<Term> assertedTerms) {
        super(pCreator);
        this.formulaCreator = (SmtInterpolFormulaCreator)pCreator;
        this.model = pModel;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    @Nullable
    public Object evaluateImpl(Term f) {
        Term out = this.model.evaluate(f);
        return this.getValue(out);
    }

    @Override
    public Iterator<Model.ValueAssignment> iterator() {
        return new TermExtractionModelIterator<Term>(this.creator, new Function<Term, Object>(){

            public Object apply(Term input) {
                return SmtInterpolModel.this.evaluateImpl(input);
            }
        }, (Iterable<Term>)this.assertedTerms);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(Term value) {
        FormulaType<?> type = this.creator.getFormulaType(value);
        if (type.isBooleanType()) {
            return value.getTheory().mTrue == value;
        }
        if (value instanceof ConstantTerm && ((ConstantTerm)value).getValue() instanceof de.uni_freiburg.informatik.ultimate.logic.Rational) {
            de.uni_freiburg.informatik.ultimate.logic.Rational rationalValue = (de.uni_freiburg.informatik.ultimate.logic.Rational)((ConstantTerm)value).getValue();
            Rational out = Rational.of((BigInteger)rationalValue.numerator(), (BigInteger)rationalValue.denominator());
            if (this.formulaCreator.getFormulaTypeOfSort(value.getSort()).isIntegerType()) {
                assert (out.isIntegral());
                return out.getNum();
            }
            return out;
        }
        return value.toString();
    }
}

