/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.SimpleAPI;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.ITerm;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessSolverContext;
import org.sosy_lab.solver.princess.PrincessStack;
import scala.Enumeration;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

class SymbolTrackingPrincessStack
implements PrincessStack {
    private final PrincessEnvironment env;
    private final SimpleAPI api;
    private final boolean usableForInterpolation;
    private final ShutdownNotifier shutdownNotifier;
    private final PrincessSolverContext.PrincessOptions princessOptions;
    private final Deque<Level> trackingStack = new ArrayDeque<Level>();

    SymbolTrackingPrincessStack(PrincessEnvironment env, SimpleAPI api, boolean usableForInterpolation, ShutdownNotifier shutdownNotifier, PrincessSolverContext.PrincessOptions princessOptions) {
        this.env = env;
        this.api = api;
        this.usableForInterpolation = usableForInterpolation;
        this.shutdownNotifier = shutdownNotifier;
        this.princessOptions = princessOptions;
    }

    public boolean canBeUsedForInterpolation() {
        return this.usableForInterpolation;
    }

    @Override
    public void push(int levels) {
        for (int i = 0; i < levels; ++i) {
            this.api.push();
            this.trackingStack.addLast(new Level());
        }
    }

    @Override
    public void pop(int levels) {
        ArrayDeque<Level> toAdd = new ArrayDeque<Level>(levels);
        for (int i = 0; i < levels; ++i) {
            this.api.pop();
            toAdd.add(this.trackingStack.removeLast());
        }
        for (Level level : toAdd) {
            this.api.addBooleanVariables(JavaConversions.iterableAsScalaIterable(level.booleanSymbols));
            this.api.addConstants(JavaConversions.iterableAsScalaIterable(level.intSymbols));
            for (IFunction function : level.functionSymbols) {
                this.api.addFunction(function);
            }
            if (this.trackingStack.isEmpty()) continue;
            this.trackingStack.getLast().mergeWithHigher(level);
        }
    }

    @Override
    public void assertTerm(IFormula booleanFormula) {
        this.api.addAssertion(this.api.abbrevSharedExpressions(booleanFormula, this.princessOptions.getMinAtomsForAbbreviation()));
    }

    @Override
    public void assertTermInPartition(IFormula booleanFormula, int index) {
        this.api.setPartitionNumber(index);
        this.assertTerm(booleanFormula);
        this.api.setPartitionNumber(-1);
    }

    @Override
    public boolean checkSat() throws SolverException {
        Enumeration.Value result = this.api.checkSat(true);
        if (result == SimpleAPI.ProverStatus$.MODULE$.Sat()) {
            return true;
        }
        if (result == SimpleAPI.ProverStatus$.MODULE$.Unsat()) {
            return false;
        }
        throw new SolverException("Princess' checkSat call returned " + result);
    }

    @Override
    public SimpleAPI.PartialModel getPartialModel() {
        return this.api.partialModel();
    }

    @Override
    public Option<Object> evalPartial(IFormula formula) {
        return this.api.evalPartial(formula);
    }

    @Override
    public List<IFormula> getInterpolants(List<Set<Integer>> partitions) {
        ArrayBuffer args = new ArrayBuffer();
        for (Set<Integer> partition : partitions) {
            args.$plus$eq((Object)JavaConversions.asScalaSet(partition).toSet());
        }
        Seq itps = this.api.getInterpolants(args.toSeq(), this.api.getInterpolants$default$2());
        assert (itps.length() == partitions.size() - 1) : "There should be (n-1) interpolants for n partitions";
        return JavaConversions.seqAsJavaList((Seq)itps);
    }

    @Override
    public void close() {
        if (this.shutdownNotifier.shouldShutdown()) {
            this.env.removeStack(this);
            this.api.shutDown();
        } else {
            this.pop(this.trackingStack.size());
            this.env.unregisterStack(this);
        }
    }

    void addSymbol(IFormula f) {
        this.api.addBooleanVariable(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().booleanSymbols.add(f);
        }
    }

    void addSymbol(ITerm f) {
        this.api.addConstant(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().intSymbols.add(f);
        }
    }

    void addSymbol(IFunction f) {
        this.api.addFunction(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().functionSymbols.add(f);
        }
    }

    private static class Level {
        List<IFormula> booleanSymbols = new ArrayList<IFormula>();
        List<ITerm> intSymbols = new ArrayList<ITerm>();
        List<IFunction> functionSymbols = new ArrayList<IFunction>();

        private Level() {
        }

        void mergeWithHigher(Level other) {
            this.booleanSymbols.addAll(other.booleanSymbols);
            this.intSymbols.addAll(other.intSymbols);
            this.functionSymbols.addAll(other.functionSymbols);
        }
    }
}

