/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5SolverContext;

class Mathsat5OptimizationProver
extends Mathsat5AbstractProver<Void>
implements OptimizationProverEnvironment {
    private final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    @Nullable
    private List<Long> objectives = null;
    private Map<Integer, Integer> objectiveMap = new HashMap<Integer, Integer>();
    private final Deque<ImmutableMap<Integer, Integer>> stack = new ArrayDeque<ImmutableMap<Integer, Integer>>();

    Mathsat5OptimizationProver(Mathsat5SolverContext pMgr, Mathsat5FormulaCreator creator) {
        super(pMgr, Mathsat5OptimizationProver.createConfig(), creator);
    }

    private static Map<String, String> createConfig() {
        return ImmutableMap.builder().put((Object)"model_generation", (Object)"true").build();
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getMsatTerm(constraint));
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        int id = this.idGenerator.getFreshId();
        this.objectiveMap.put(id, this.objectiveMap.size());
        Mathsat5NativeApi.msat_push_maximize(this.curEnv, Mathsat5FormulaManager.getMsatTerm(objective), null, null);
        return id;
    }

    @Override
    public int minimize(Formula objective) {
        int id = this.idGenerator.getFreshId();
        this.objectiveMap.put(id, this.objectiveMap.size());
        Mathsat5NativeApi.msat_push_minimize(this.curEnv, Mathsat5FormulaManager.getMsatTerm(objective), null, null);
        return id;
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        boolean out = Mathsat5NativeApi.msat_check_sat(this.curEnv);
        if (out) {
            if (!this.objectiveMap.isEmpty()) {
                this.objectives = new ArrayList<Long>();
                long it = Mathsat5NativeApi.msat_create_objective_iterator(this.curEnv);
                while (Mathsat5NativeApi.msat_objective_iterator_has_next(it) != 0) {
                    long[] objectivePtr = new long[1];
                    int status = Mathsat5NativeApi.msat_objective_iterator_next(it, objectivePtr);
                    assert (status == 0);
                    this.objectives.add(objectivePtr[0]);
                }
                Mathsat5NativeApi.msat_destroy_objective_iterator(it);
            }
            return OptimizationProverEnvironment.OptStatus.OPT;
        }
        return OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public void push() {
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
        this.stack.add((ImmutableMap<Integer, Integer>)ImmutableMap.copyOf(this.objectiveMap));
    }

    @Override
    @Nullable
    public Void push(BooleanFormula f) {
        this.push();
        this.addConstraint(f);
        return null;
    }

    @Override
    public void pop() {
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
        this.objectiveMap = new HashMap<Integer, Integer>((Map)this.stack.pop());
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.getValue(handle);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.getValue(handle);
    }

    private Optional<Rational> getValue(int handle) {
        assert (this.objectiveMap.get(handle) != null);
        assert (this.objectives != null);
        assert (this.objectives.get(this.objectiveMap.get(handle)) != null);
        long objective = this.objectives.get(this.objectiveMap.get(handle));
        int isUnbounded = Mathsat5NativeApi.msat_objective_value_is_unbounded(this.curEnv, objective, 0);
        if (isUnbounded == 1) {
            return Optional.absent();
        }
        assert (isUnbounded == 0);
        String objectiveValue = Mathsat5NativeApi.msat_objective_value_repr(this.curEnv, objective, 0);
        return Optional.of((Object)Rational.ofString((String)objectiveValue));
    }

    @Override
    public Model getModel() throws SolverException {
        long it = Mathsat5NativeApi.msat_create_objective_iterator(this.curEnv);
        long[] objectivePtr = new long[1];
        while (Mathsat5NativeApi.msat_objective_iterator_has_next(it) != 0) {
            int status = Mathsat5NativeApi.msat_objective_iterator_next(it, objectivePtr);
            assert (status == 0);
        }
        Mathsat5NativeApi.msat_destroy_objective_iterator(it);
        assert (objectivePtr[0] != 0L);
        Mathsat5NativeApi.msat_set_model(this.curEnv, objectivePtr[0]);
        return super.getModel();
    }
}

