/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;

class Mathsat5Model
extends AbstractModel<Long, Long, Long> {
    private final long model;
    private final Mathsat5FormulaCreator formulaCreator;
    @Nullable
    private ImmutableList<Model.ValueAssignment> modelAssignments = null;

    private Mathsat5Model(long model, Mathsat5FormulaCreator creator) {
        super(creator);
        this.model = model;
        this.formulaCreator = creator;
    }

    static Mathsat5Model create(long model, Mathsat5FormulaCreator creator) {
        Mathsat5Model out = new Mathsat5Model(model, creator);
        creator.storeModelPhantomReference(out, model);
        creator.cleanupModelReferences();
        return out;
    }

    @Override
    public Object evaluateImpl(Long f) {
        long term = Mathsat5NativeApi.msat_model_eval(this.model, f);
        return this.formulaCreator.convertValue(f, term);
    }

    @Override
    public Iterator<Model.ValueAssignment> iterator() {
        if (this.modelAssignments == null) {
            this.modelAssignments = this.generateAssignments();
        }
        return this.modelAssignments.iterator();
    }

    private ImmutableList<Model.ValueAssignment> generateAssignments() {
        ImmutableList.Builder assignments = ImmutableList.builder();
        long modelIterator = Mathsat5NativeApi.msat_model_create_iterator(this.model);
        while (Mathsat5NativeApi.msat_model_iterator_has_next(modelIterator)) {
            long[] key = new long[1];
            long[] value = new long[1];
            if (Mathsat5NativeApi.msat_model_iterator_next(modelIterator, key, value)) {
                throw new NoSuchElementException();
            }
            Formula fKey = this.creator.encapsulateWithTypeOf(key[0]);
            Object fValue = this.formulaCreator.convertValue(key[0], value[0]);
            ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
            for (int i = 0; i < Mathsat5NativeApi.msat_term_arity(key[0]); ++i) {
                long arg = Mathsat5NativeApi.msat_term_get_arg(key[0], i);
                argumentInterpretation.add(this.evaluateImpl(arg));
            }
            assignments.add((Object)new Model.ValueAssignment(fKey, this.formulaCreator.getName(key[0]), fValue, argumentInterpretation));
        }
        Mathsat5NativeApi.msat_destroy_model_iterator(modelIterator);
        return assignments.build();
    }
}

