/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.tactics;

import com.google.common.collect.Iterables;
import java.util.List;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.basicimpl.tactics.CNFVisitor;
import org.sosy_lab.solver.basicimpl.tactics.NNFVisitor;

public enum Tactic {
    NNF("nnf", "Convert the formula to NNF. Equivalence, ITE and implications are resolved by replacing them with appropriate formulas consisting of and/or/not"){

        @Override
        public BooleanFormula applyDefault(FormulaManager pFmgr, BooleanFormula pF) {
            return pFmgr.getBooleanFormulaManager().visit(new NNFVisitor(pFmgr), pF);
        }
    }
    ,
    CNF_LIGHT("cnf", "Convert the formula to an approximated CNF. This tactic creates a CNF formula but still may have some 'ands' which are deeper stacked in the formula and thus would create too much conjuncts when creating a full CNF."){

        @Override
        public BooleanFormula applyDefault(FormulaManager pFmgr, BooleanFormula pF) {
            BooleanFormula nnf;
            BooleanFormulaManager bfmgr = pFmgr.getBooleanFormulaManager();
            List<BooleanFormula> conjuncts = bfmgr.visit(new CNFVisitor(bfmgr, 3), nnf = bfmgr.visit(new NNFVisitor(pFmgr), pF));
            if (conjuncts.size() == 1) {
                return (BooleanFormula)Iterables.getOnlyElement(conjuncts);
            }
            return pFmgr.getBooleanFormulaManager().and(conjuncts);
        }
    }
    ,
    CNF("cnf", "Convert the formula to CNF. This tactic creates a formula which is in some cases exponentially bigger. E.g. (x /\\ y) \\/ (z /\\ w) will have 2^n clauses in CNF afterwards."){

        @Override
        public BooleanFormula applyDefault(FormulaManager pFmgr, BooleanFormula pF) {
            BooleanFormula nnf;
            BooleanFormulaManager bfmgr = pFmgr.getBooleanFormulaManager();
            List<BooleanFormula> conjuncts = bfmgr.visit(new CNFVisitor(bfmgr, -1), nnf = bfmgr.visit(new NNFVisitor(pFmgr), pF));
            if (conjuncts.size() == 1) {
                return (BooleanFormula)Iterables.getOnlyElement(conjuncts);
            }
            return pFmgr.getBooleanFormulaManager().and(conjuncts);
        }
    }
    ,
    TSEITIN_CNF("tseitin-cnf", "Convert the formula to CNF using Tseitin encoding. Note that the resulting formula is not equivalent but only equisatisfiable."),
    QE_LIGHT("qe-light", "Perform light quantifier elimination"),
    QE("qe", "Perform quantifier elimination");

    private final String name;
    private final String description;

    private Tactic(String pName, String pDescription) {
        this.name = pName;
        this.description = pDescription;
    }

    public String getTacticName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BooleanFormula applyDefault(FormulaManager pFmgr, BooleanFormula pF) throws InterruptedException {
        throw new UnsupportedOperationException(String.format("The tactic %s is not supported by the current solver has no default implementation.", this.getTacticName()));
    }
}

