/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.InterpolatingProverEnvironmentWithAssumptions;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.visitors.BooleanFormulaTransformationVisitor;

public class InterpolatingProverWithAssumptionsWrapper<T>
implements InterpolatingProverEnvironmentWithAssumptions<T> {
    private final List<T> solverAssumptionsFromPush;
    private final List<BooleanFormula> solverAssumptionsAsFormula;
    private final InterpolatingProverEnvironment<T> delegate;
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bmgr;

    public InterpolatingProverWithAssumptionsWrapper(InterpolatingProverEnvironment<T> pDelegate, FormulaManager pFmgr) {
        this.delegate = (InterpolatingProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.solverAssumptionsFromPush = new ArrayList<T>();
        this.solverAssumptionsAsFormula = new ArrayList<BooleanFormula>();
        this.fmgr = (FormulaManager)Preconditions.checkNotNull((Object)pFmgr);
        this.bmgr = this.fmgr.getBooleanFormulaManager();
    }

    @Override
    public T push(BooleanFormula pF) {
        this.clearAssumptions();
        return this.delegate.push(pF);
    }

    @Override
    public BooleanFormula getInterpolant(List<T> pFormulasOfA) throws SolverException, InterruptedException {
        ArrayList completeListOfA = Lists.newArrayList(pFormulasOfA);
        completeListOfA.addAll(this.solverAssumptionsFromPush);
        BooleanFormula interpolant = this.delegate.getInterpolant(completeListOfA);
        if (!this.solverAssumptionsAsFormula.isEmpty()) {
            interpolant = this.bmgr.visit(new RemoveAssumptionsFromFormulaVisitor(), interpolant);
        }
        return interpolant;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> pPartitionedFormulas) throws SolverException, InterruptedException {
        if (this.solverAssumptionsAsFormula.isEmpty()) {
            return this.delegate.getSeqInterpolants(pPartitionedFormulas);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<T>> pPartitionedFormulas, int[] pStartOfSubTree) throws SolverException, InterruptedException {
        if (this.solverAssumptionsAsFormula.isEmpty()) {
            return this.delegate.getTreeInterpolants(pPartitionedFormulas, pStartOfSubTree);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void pop() {
        this.clearAssumptions();
        this.delegate.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) {
        return this.delegate.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.clearAssumptions();
        this.delegate.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.clearAssumptions();
        return this.delegate.isUnsat();
    }

    @Override
    public Model getModel() throws SolverException {
        return this.delegate.getModel();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isUnsatWithAssumptions(List<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.clearAssumptions();
        this.solverAssumptionsAsFormula.addAll(assumptions);
        for (BooleanFormula formula : assumptions) {
            this.solverAssumptionsFromPush.add(this.delegate.push(formula));
        }
        return this.delegate.isUnsat();
    }

    private void clearAssumptions() {
        for (int i = 0; i < this.solverAssumptionsAsFormula.size(); ++i) {
            this.delegate.pop();
        }
        this.solverAssumptionsAsFormula.clear();
        this.solverAssumptionsFromPush.clear();
    }

    class RemoveAssumptionsFromFormulaVisitor
    extends BooleanFormulaTransformationVisitor {
        private RemoveAssumptionsFromFormulaVisitor() {
            super(InterpolatingProverWithAssumptionsWrapper.this.fmgr, new HashMap<BooleanFormula, BooleanFormula>());
        }

        @Override
        public BooleanFormula visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> decl) {
            if (decl.getKind() == FunctionDeclarationKind.VAR) {
                String varName = decl.getName();
                if (this.solverAssumptionsContainsVar(varName)) {
                    return InterpolatingProverWithAssumptionsWrapper.this.bmgr.makeBoolean(true);
                }
                return InterpolatingProverWithAssumptionsWrapper.this.bmgr.makeVariable(varName);
            }
            return atom;
        }

        private boolean solverAssumptionsContainsVar(String variableName) {
            for (BooleanFormula solverVar : InterpolatingProverWithAssumptionsWrapper.this.solverAssumptionsAsFormula) {
                if (!InterpolatingProverWithAssumptionsWrapper.this.fmgr.extractVariables(solverVar).keySet().contains(variableName)) continue;
                return true;
            }
            return false;
        }
    }
}

