/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.UFManager;
import org.sosy_lab.solver.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.FunctionDeclarationImpl;

public abstract class AbstractUFManager<TFormulaInfo, TFunctionDecl, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFunctionDecl>
implements UFManager {
    protected AbstractUFManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFunctionDecl> pCreator) {
        super(pCreator);
    }

    protected abstract TFunctionDecl declareUninterpretedFunctionImpl(String var1, TType var2, List<TType> var3);

    @Override
    public final <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgTypes) {
        Preconditions.checkArgument((!pArgTypes.contains(FormulaType.BooleanType) ? 1 : 0) != 0, (Object)"Uninterpreted functions with boolean arguments are currently not supported in JavaSMT.");
        ArrayList argTypes = new ArrayList(pArgTypes.size());
        for (FormulaType<?> argtype : pArgTypes) {
            argTypes.add(this.toSolverType(argtype));
        }
        return FunctionDeclarationImpl.of(pName, FunctionDeclarationKind.UF, pArgTypes, pReturnType, this.declareUninterpretedFunctionImpl(pName, this.toSolverType(pReturnType), argTypes));
    }

    @Override
    public <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUF(pName, pReturnType, Arrays.asList(pArgs));
    }

    protected abstract TFormulaInfo createUninterpretedFunctionCallImpl(TFunctionDecl var1, List<TFormulaInfo> var2);

    @Override
    public <T extends Formula> T callUF(FunctionDeclaration<T> funcType, Formula ... args) {
        return this.formulaCreator.callFunction(funcType, (List<Formula>)ImmutableList.copyOf((Object[])args));
    }

    @Override
    public final <T extends Formula> T callUF(FunctionDeclaration<T> pFunc, List<? extends Formula> pArgs) {
        return this.formulaCreator.callFunction(pFunc, pArgs);
    }

    @Override
    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        ImmutableList argTypes = FluentIterable.from(pArgs).transform(new Function<Formula, FormulaType<?>>(){

            public FormulaType<?> apply(Formula pArg0) {
                return AbstractUFManager.this.getFormulaCreator().getFormulaType(pArg0);
            }
        }).toList();
        FunctionDeclaration<T> func = this.declareUF(name, pReturnType, (List<FormulaType<?>>)argTypes);
        return this.callUF(func, pArgs);
    }
}

