/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.common.ChildFirstPatternClassLoader;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.NullLogManager;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.mathsat5.Mathsat5SolverContext;
import org.sosy_lab.solver.princess.PrincessSolverContext;
import org.sosy_lab.solver.z3java.Z3SolverContext;

@Options(prefix="solver", deprecatedPrefix="cpa.predicate")
public class SolverContextFactory {
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    private boolean logAllQueries = false;
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    @Nullable
    private PathCounterTemplate logfile = PathCounterTemplate.ofFormatString((String)"smtquery.%03d.smt2");
    @Option(secure=true, description="Random seed for SMT solver.")
    private long randomSeed = 42L;
    @Option(secure=true, description="Which SMT solver to use.")
    private Solvers solver = Solvers.SMTINTERPOL;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private static final Pattern SMTINTERPOL_CLASSES = Pattern.compile("^(org\\.sosy_lab\\.solver\\.smtinterpol|de\\.uni_freiburg\\.informatik\\.ultimate|java_cup\\.runtime|org\\.apache\\.log4j)\\..*");
    private static final String SMTINTERPOL_FACTORY_CLASS = "org.sosy_lab.solver.smtinterpol.SmtInterpolSolverFactory";
    private static final String SMTINTERPOL_CLASS = "de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol";
    private static WeakReference<ClassLoader> smtInterpolClassLoader = new WeakReference<Object>(null);
    private static final AtomicInteger smtInterpolLoadingCount = new AtomicInteger(0);

    public SolverContextFactory(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.config = pConfig;
        if (!this.logAllQueries) {
            this.logfile = null;
        }
    }

    public SolverContext generateContext() throws InvalidConfigurationException {
        return this.generateContext(this.solver);
    }

    public SolverContext generateContext(Solvers solverToCreate) throws InvalidConfigurationException {
        try {
            switch (solverToCreate) {
                case SMTINTERPOL: {
                    return this.loadSmtInterpol().create(this.config, this.logger, this.shutdownNotifier, this.logfile, this.randomSeed);
                }
                case MATHSAT5: {
                    return Mathsat5SolverContext.create(this.logger, this.config, this.shutdownNotifier, this.logfile, this.randomSeed);
                }
                case Z3: {
                    return org.sosy_lab.solver.z3.Z3SolverContext.create(this.logger, this.config, this.shutdownNotifier, this.logfile, this.randomSeed);
                }
                case Z3JAVA: {
                    return Z3SolverContext.create(this.logger, this.config, this.shutdownNotifier, this.logfile, this.randomSeed);
                }
                case PRINCESS: {
                    return PrincessSolverContext.create(this.config, this.logger, this.shutdownNotifier, this.logfile);
                }
            }
            throw new AssertionError((Object)"no solver selected");
        }
        catch (UnsatisfiedLinkError e) {
            throw new InvalidConfigurationException(String.format("The SMT solver %s is not available on this machine because of missing libraries (%s). You may experiment with SMTInterpol by setting solver.solver=SMTInterpol.", new Object[]{solverToCreate, e.getMessage()}), (Throwable)e);
        }
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext();
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier, Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext(solver);
    }

    public static SolverContext createSolverContext(Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(Configuration.defaultConfiguration(), NullLogManager.getInstance(), ShutdownNotifier.createDummy()).generateContext(solver);
    }

    private InnerUtilFactory loadSmtInterpol() {
        try {
            ClassLoader classLoader = SolverContextFactory.getClassLoaderForSmtInterpol(this.logger);
            Class<?> factoryClass = classLoader.loadClass(SMTINTERPOL_FACTORY_CLASS);
            Constructor<?> factoryConstructor = factoryClass.getConstructor(new Class[0]);
            return (InnerUtilFactory)factoryConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to load SmtInterpol", (Throwable)e);
        }
    }

    private static ClassLoader getClassLoaderForSmtInterpol(LogManager logger) {
        String smtinterpolClassFile;
        URL smtinterpolUrl;
        ClassLoader classLoader = (ClassLoader)smtInterpolClassLoader.get();
        if (classLoader != null) {
            return classLoader;
        }
        if (smtInterpolLoadingCount.incrementAndGet() > 1) {
            logger.log(Level.INFO, new Object[]{"Repeated loading of SmtInterpol"});
        }
        if ((smtinterpolUrl = (classLoader = SolverContextFactory.class.getClassLoader()).getResource(smtinterpolClassFile = SMTINTERPOL_CLASS.replace('.', File.separatorChar) + ".class")) != null && smtinterpolUrl.getProtocol().equals("jar") && smtinterpolUrl.getFile().contains("!")) {
            try {
                smtinterpolUrl = new URL(smtinterpolUrl.getFile().substring(0, smtinterpolUrl.getFile().lastIndexOf(33)));
                URL[] urls = new URL[]{smtinterpolUrl, SolverContextFactory.class.getProtectionDomain().getCodeSource().getLocation()};
                classLoader = new ChildFirstPatternClassLoader(SMTINTERPOL_CLASSES, urls, classLoader);
            }
            catch (MalformedURLException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Could not create proper classpath for SMTInterpol, loading correct java-cup classes may fail.");
            }
        } else {
            logger.log(Level.WARNING, new Object[]{"Could not create proper classpath for SMTInterpol because location of SMTInterpol classes is unexpected, loading correct java-cup classes may fail. Location of SMTInterpol is ", smtinterpolUrl});
        }
        smtInterpolClassLoader = new WeakReference<ClassLoader>(classLoader);
        return classLoader;
    }

    public static interface InnerUtilFactory {
        public SolverContext create(Configuration var1, LogManager var2, ShutdownNotifier var3, @Nullable PathCounterTemplate var4, long var5) throws InvalidConfigurationException;
    }

    @VisibleForTesting
    public static enum Solvers {
        MATHSAT5,
        SMTINTERPOL,
        Z3,
        Z3JAVA,
        PRINCESS;

    }
}

