/*
 *
 *  *  JavaSMT is an API wrapper for a collection of SMT solvers.
 *  *  This file is part of JavaSMT.
 *  *
 *  *  Copyright (C) 2007-2016  Dirk Beyer
 *  *  All rights reserved.
 *  *
 *  *  Licensed under the Apache License, Version 2.0 (the "License");
 *  *  you may not use this file except in compliance with the License.
 *  *  You may obtain a copy of the License at
 *  *
 *  *      http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  *  Unless required by applicable law or agreed to in writing, software
 *  *  distributed under the License is distributed on an "AS IS" BASIS,
 *  *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *  See the License for the specific language governing permissions and
 *  *  limitations under the License.
 *
 *
 */

package org.sosy_lab.solver.test;

import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverContextFactory.Solvers;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.SolverContext;

public class MemoryApp {
  public static void main (String[] args) throws Exception {
    new MemoryApp().run();
  }

  private final FormulaManager fmgr;
  private final BooleanFormulaManager bfmgr;
  private final IntegerFormulaManager ifmgr;
  private final SolverContext context;

  MemoryApp() throws InvalidConfigurationException {
    Configuration config = Configuration.builder()
        .build();
    LogManager logger = new BasicLogManager(config);
    ShutdownNotifier notifier = ShutdownManager.create().getNotifier();
    context = SolverContextFactory.createSolverContext(config, logger, notifier,
        Solvers.MATHSAT5);
    fmgr = context.getFormulaManager();
    bfmgr = fmgr.getBooleanFormulaManager();
    ifmgr = fmgr.getIntegerFormulaManager();
  }

  void run() throws InterruptedException {
    System.out.printf("Running...");
    int i = 0;
    while (true) {
      BooleanFormula out = bfmgr.or(
          bfmgr.and(
              bfmgr.makeVariable("a"),
              bfmgr.makeVariable("b")
          ),
          bfmgr.and(
              bfmgr.makeVariable("c"),
              bfmgr.makeVariable("d")
          )
      );
    }
  }
}
