/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Global;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.InterpolationContext;
import com.microsoft.z3.Log;
import com.microsoft.z3.Params;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Version;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.util.HashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractSolverContext;
import org.sosy_lab.solver.z3java.Z3ArrayFormulaManager;
import org.sosy_lab.solver.z3java.Z3BitvectorFormulaManager;
import org.sosy_lab.solver.z3java.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3FormulaManager;
import org.sosy_lab.solver.z3java.Z3IntegerFormulaManager;
import org.sosy_lab.solver.z3java.Z3InterpolatingProver;
import org.sosy_lab.solver.z3java.Z3OptimizationProver;
import org.sosy_lab.solver.z3java.Z3QuantifiedFormulaManager;
import org.sosy_lab.solver.z3java.Z3RationalFormulaManager;
import org.sosy_lab.solver.z3java.Z3TheoremProver;
import org.sosy_lab.solver.z3java.Z3UFManager;

@Options(prefix="solver.z3java")
public final class Z3SolverContext
extends AbstractSolverContext {
    @Option(secure=true, description="Engine to use for the optimization", values={"basic", "farkas", "symba"})
    String optimizationEngine = "basic";
    @Option(secure=true, description="Ordering for objectives in the optimization context", values={"lex", "pareto", "box"})
    String objectivePrioritizationMode = "box";
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;
    private final Params z3params;
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;
    private final Z3FormulaCreator creator;
    private final Z3FormulaManager manager;
    private static final String OPT_ENGINE_CONFIG_KEY = "optsmt_engine";
    private static final String OPT_PRIORITY_CONFIG_KEY = "priority";

    private Z3SolverContext(Z3FormulaCreator pFormulaCreator, Configuration config, Params pZ3params, ShutdownNotifier.ShutdownRequestListener pInterruptListener, ShutdownNotifier pShutdownNotifier, LogManager pLogger, Z3FormulaManager pManager) throws InvalidConfigurationException {
        super(config, pLogger, pManager);
        this.creator = pFormulaCreator;
        config.inject((Object)this);
        this.z3params = pZ3params;
        this.interruptListener = pInterruptListener;
        pShutdownNotifier.register(this.interruptListener);
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
        this.manager = pManager;
    }

    public static synchronized Z3SolverContext create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed) throws InvalidConfigurationException {
        ExtraOptions extraOptions = new ExtraOptions();
        config.inject((Object)extraOptions);
        if (solverLogfile != null) {
            logger.log(Level.WARNING, new Object[]{"Z3 does not support dumping a log file in SMTLIB format. Please use the option solver.z3java.log for a Z3-specific log instead."});
        }
        if (NativeLibraries.OS.guessOperatingSystem() == NativeLibraries.OS.WINDOWS) {
            NativeLibraries.loadLibrary((String)"libz3java");
        }
        NativeLibraries.loadLibrary((String)"z3java");
        if (extraOptions.log != null) {
            Path absolutePath = extraOptions.log.toAbsolutePath();
            Log.open((String)absolutePath.toString());
        }
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("MODEL", "true");
        if (extraOptions.requireProofs) {
            cfg.put("PROOF", "true");
        }
        Global.setParameter((String)"smt.random_seed", (String)String.valueOf(randomSeed));
        InterpolationContext context = new InterpolationContext(cfg);
        ShutdownNotifier.ShutdownRequestListener interruptListener = new ShutdownNotifier.ShutdownRequestListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void shutdownRequested(String reason) {
                this.val$context.interrupt();
            }
        };
        BoolSort boolSort = context.getBoolSort();
        IntSort integerSort = context.getIntSort();
        RealSort realSort = context.getRealSort();
        context.setPrintMode(Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT);
        Params z3params = context.mkParams();
        z3params.add(":random-seed", (int)randomSeed);
        Z3FormulaCreator creator = new Z3FormulaCreator((Context)context, (Sort)boolSort, (Sort)integerSort, (Sort)realSort);
        Z3UFManager functionTheory = new Z3UFManager(creator);
        Z3BooleanFormulaManager booleanTheory = new Z3BooleanFormulaManager(creator);
        Z3IntegerFormulaManager integerTheory = new Z3IntegerFormulaManager(creator);
        Z3RationalFormulaManager rationalTheory = new Z3RationalFormulaManager(creator);
        Z3BitvectorFormulaManager bitvectorTheory = new Z3BitvectorFormulaManager(creator);
        Z3QuantifiedFormulaManager quantifierManager = new Z3QuantifiedFormulaManager(creator);
        Z3ArrayFormulaManager arrayManager = new Z3ArrayFormulaManager(creator);
        Z3FormulaManager manager = new Z3FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, quantifierManager, arrayManager);
        return new Z3SolverContext(creator, config, z3params, interruptListener, pShutdownNotifier, logger, manager);
    }

    @Override
    public Z3FormulaManager getFormulaManager() {
        return this.manager;
    }

    @Override
    public ProverEnvironment newProverEnvironment0(SolverContext.ProverOptions ... options) {
        return new Z3TheoremProver(this.creator, this.manager, this.z3params, this.shutdownNotifier, options);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new Z3InterpolatingProver(this.creator, this.z3params, this.shutdownNotifier);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        Z3OptimizationProver out = new Z3OptimizationProver(this.getFormulaManager(), this.creator, this.shutdownNotifier, this.logger);
        out.setParam(OPT_ENGINE_CONFIG_KEY, this.optimizationEngine);
        out.setParam(OPT_PRIORITY_CONFIG_KEY, this.objectivePrioritizationMode);
        return out;
    }

    @Override
    public String getVersion() {
        return "Z3 " + Version.getString();
    }

    @Override
    public void close() {
    }

    @Options(prefix="solver.z3java")
    private static class ExtraOptions {
        @Option(secure=true, description="Require proofs from SMT solver")
        boolean requireProofs = true;
        @Option(secure=true, description="Activate replayable logging in Z3. The log can be given as an input to the solver and replayed.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        @Nullable
        Path log = null;

        private ExtraOptions() {
        }
    }
}

