/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Sort;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

abstract class Z3NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Expr, Sort, Context, ParamFormulaType, ResultFormulaType, FuncDecl> {
    protected final Context z3context;

    Z3NumeralFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
        this.z3context = (Context)pCreator.getEnv();
    }

    static ArithExpr toAE(Expr e) {
        return (ArithExpr)e;
    }

    private static ArithExpr[] toAE(Collection<Expr> e) {
        return e.toArray(new ArithExpr[e.size()]);
    }

    protected abstract Sort getNumeralType();

    @Override
    protected boolean isNumeral(Expr val) {
        return val.isNumeral();
    }

    @Override
    protected Expr makeNumberImpl(long i) {
        Sort sort = this.getNumeralType();
        return this.z3context.mkNumeral(i, sort);
    }

    @Override
    protected Expr makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Expr makeNumberImpl(String pI) {
        Sort sort = this.getNumeralType();
        return this.z3context.mkNumeral(pI, sort);
    }

    @Override
    protected Expr makeVariableImpl(String varName) {
        Sort type = this.getNumeralType();
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Expr negate(Expr pNumber) {
        IntNum minusOne = this.z3context.mkInt(-1);
        return this.z3context.mkMul(new ArithExpr[]{minusOne, Z3NumeralFormulaManager.toAE(pNumber)});
    }

    @Override
    public Expr add(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkAdd(new ArithExpr[]{Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2)});
    }

    @Override
    public Expr sumImpl(List<Expr> operands) {
        return this.z3context.mkAdd(Z3NumeralFormulaManager.toAE(operands));
    }

    @Override
    public Expr subtract(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkSub(new ArithExpr[]{Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2)});
    }

    @Override
    public Expr divide(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkDiv(Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2));
    }

    @Override
    public Expr multiply(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkMul(new ArithExpr[]{Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2)});
    }

    @Override
    protected Expr modularCongruence(Expr pNumber1, Expr pNumber2, long pModulo) {
        return this.z3context.mkTrue();
    }

    @Override
    public Expr equal(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkEq((Expr)Z3NumeralFormulaManager.toAE(pNumber1), (Expr)Z3NumeralFormulaManager.toAE(pNumber2));
    }

    @Override
    public Expr greaterThan(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkGt(Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2));
    }

    @Override
    public Expr greaterOrEquals(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkGe(Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2));
    }

    @Override
    public Expr lessThan(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkLt(Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2));
    }

    @Override
    public Expr lessOrEquals(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkLe(Z3NumeralFormulaManager.toAE(pNumber1), Z3NumeralFormulaManager.toAE(pNumber2));
    }
}

