/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.ApplyResult;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Goal;
import com.microsoft.z3.Tactic;
import org.sosy_lab.solver.SolverException;

class Z3NativeApiHelpers {
    private Z3NativeApiHelpers() {
    }

    static BoolExpr applyTactics(Context z3context, BoolExpr pF, String ... pTactics) throws InterruptedException, SolverException {
        BoolExpr overallResult = pF;
        for (String tactic : pTactics) {
            overallResult = Z3NativeApiHelpers.applyTactic(z3context, overallResult, tactic);
        }
        return overallResult;
    }

    static BoolExpr applyTactic(Context pContext, BoolExpr pOverallResult, String tactic) {
        Tactic tseitinTactic = pContext.mkTactic(tactic);
        Goal goal = pContext.mkGoal(true, false, false);
        goal.add(new BoolExpr[]{pOverallResult});
        ApplyResult result = tseitinTactic.apply(goal);
        return Z3NativeApiHelpers.applyResultToAST(pContext, result);
    }

    private static BoolExpr applyResultToAST(Context pContext, ApplyResult pResult) {
        int subgoalsCount = pResult.getNumSubgoals();
        BoolExpr[] goalFormulas = new BoolExpr[subgoalsCount];
        Goal[] subGoals = pResult.getSubgoals();
        for (int i = 0; i < subgoalsCount; ++i) {
            goalFormulas[i] = Z3NativeApiHelpers.goalToAST(pContext, subGoals[i]);
        }
        return goalFormulas.length == 1 ? goalFormulas[0] : pContext.mkOr(goalFormulas);
    }

    private static BoolExpr goalToAST(Context pContext, Goal pSubGoals) {
        BoolExpr[] subgoalFormulas = pSubGoals.getFormulas();
        return subgoalFormulas.length == 1 ? subgoalFormulas[0] : pContext.mkAnd(subgoalFormulas);
    }
}

