/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Sort;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.basicimpl.TermExtractionModelIterator;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

class Z3Model
extends AbstractModel<Expr, Sort, Context> {
    private final Model model;
    private final ImmutableList<BooleanFormula> trackedConstraints;
    private final Z3FormulaCreator creator;

    Z3Model(Model pModel, Z3FormulaCreator pCreator, List<BooleanFormula> pTrackedConstraints) {
        super(pCreator);
        this.model = pModel;
        this.creator = pCreator;
        this.trackedConstraints = ImmutableList.copyOf(pTrackedConstraints);
    }

    @Override
    @Nullable
    public Object evaluateImpl(Expr f) {
        return this.creator.convertValue(this.model.eval(f, true));
    }

    @Override
    public Iterator<Model.ValueAssignment> iterator() {
        return new TermExtractionModelIterator<Expr>(this.creator, new Function<Expr, Object>(){

            public Object apply(Expr input) {
                return Z3Model.this.evaluateImpl(input);
            }
        }, Iterables.transform(this.trackedConstraints, (Function)new Function<BooleanFormula, Expr>(){

            public Expr apply(BooleanFormula input) {
                return Z3Model.this.creator.extractInfo(input);
            }
        }));
    }

    @Override
    public String toString() {
        return this.model.toString();
    }
}

