/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.Sort;
import java.math.BigDecimal;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3NumeralFormulaManager;

class Z3IntegerFormulaManager
extends Z3NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Z3IntegerFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
    }

    private static IntExpr toIE(Expr e) {
        return (IntExpr)e;
    }

    @Override
    public FormulaType<NumeralFormula.IntegerFormula> getFormulaType() {
        return FormulaType.IntegerType;
    }

    @Override
    protected Sort getNumeralType() {
        return (Sort)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Expr makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Expr makeNumberImpl(BigDecimal pNumber) {
        return (Expr)this.decimalAsInteger(pNumber);
    }

    @Override
    public Expr modulo(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkMod(Z3IntegerFormulaManager.toIE(pNumber1), Z3IntegerFormulaManager.toIE(pNumber2));
    }

    @Override
    protected Expr modularCongruence(Expr pNumber1, Expr pNumber2, long pModulo) {
        if (pModulo > 0L) {
            Expr n = this.makeNumberImpl(pModulo);
            Expr x = this.subtract(pNumber1, pNumber2);
            return this.z3context.mkEq(x, (Expr)this.z3context.mkMul(new ArithExpr[]{Z3IntegerFormulaManager.toAE(n), this.z3context.mkDiv(Z3IntegerFormulaManager.toAE(x), Z3IntegerFormulaManager.toAE(n))}));
        }
        return this.z3context.mkTrue();
    }
}

