/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.z3java.Z3ArrayFormulaManager;
import org.sosy_lab.solver.z3java.Z3BitvectorFormulaManager;
import org.sosy_lab.solver.z3java.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3IntegerFormulaManager;
import org.sosy_lab.solver.z3java.Z3NativeApiHelpers;
import org.sosy_lab.solver.z3java.Z3NumeralFormulaManager;
import org.sosy_lab.solver.z3java.Z3QuantifiedFormulaManager;
import org.sosy_lab.solver.z3java.Z3RationalFormulaManager;
import org.sosy_lab.solver.z3java.Z3SolverContext;
import org.sosy_lab.solver.z3java.Z3UFManager;

final class Z3FormulaManager
extends AbstractFormulaManager<Expr, Sort, Context, FuncDecl> {
    private static final ImmutableMap<Tactic, String> Z3_TACTICS = ImmutableMap.builder().put((Object)Tactic.NNF, (Object)"nnf").put((Object)Tactic.CNF, (Object)"cnf").put((Object)Tactic.TSEITIN_CNF, (Object)"tseitin-cnf").put((Object)Tactic.QE, (Object)"qe").put((Object)Tactic.QE_LIGHT, (Object)"qe-light").build();

    Z3FormulaManager(Z3FormulaCreator pFormulaCreator, Z3UFManager pFunctionManager, Z3BooleanFormulaManager pBooleanManager, Z3IntegerFormulaManager pIntegerManager, Z3RationalFormulaManager pRationalManager, Z3BitvectorFormulaManager pBitpreciseManager, Z3QuantifiedFormulaManager pQuantifiedManager, Z3ArrayFormulaManager pArrayManager) {
        super(pFormulaCreator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, null, pQuantifiedManager, pArrayManager);
    }

    @Override
    public BooleanFormula parse(String str) throws IllegalArgumentException {
        Symbol[] sortSymbols = new Symbol[]{};
        Sort[] sorts = new Sort[]{};
        Symbol[] declSymbols = new Symbol[]{};
        FuncDecl[] decls = new FuncDecl[]{};
        BoolExpr e = ((Context)this.getEnvironment()).parseSMTLIB2String(str, sortSymbols, sorts, declSymbols, decls);
        return this.getFormulaCreator().encapsulateBoolean(e);
    }

    @Override
    protected Expr applyTacticImpl(Expr input, Tactic tactic) throws InterruptedException {
        String z3TacticName = (String)Z3_TACTICS.get((Object)tactic);
        if (z3TacticName != null) {
            return Z3NativeApiHelpers.applyTactic((Context)this.getFormulaCreator().getEnv(), Z3BooleanFormulaManager.toBool(input), z3TacticName);
        }
        return super.applyTacticImpl(input, tactic);
    }

    @Override
    public Appender dumpFormula(final Expr expr) {
        assert (this.getFormulaCreator().getFormulaType(expr) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                Solver z3solver = ((Context)Z3FormulaManager.this.getEnvironment()).mkSolver();
                z3solver.add(new BoolExpr[]{(BoolExpr)expr});
                String serialized = z3solver.toString();
                out.append(serialized);
            }
        };
    }

    @Override
    protected Expr simplify(Expr pF) {
        return pF.simplify();
    }

    @Override
    protected List<? extends Expr> splitNumeralEqualityIfPossible(Expr pF) {
        Context z3context = (Context)this.getFormulaCreator().getEnv();
        if (pF.isEq() && pF.getNumArgs() == 2) {
            Expr arg0 = pF.getArgs()[0];
            Expr arg1 = pF.getArgs()[1];
            Z3_sort_kind sortKind = arg0.getSort().getSortKind();
            assert (sortKind == arg1.getSort().getSortKind());
            if (sortKind == Z3_sort_kind.Z3_BV_SORT) {
                BoolExpr out1 = z3context.mkBVULE(Z3BitvectorFormulaManager.toBV(arg0), Z3BitvectorFormulaManager.toBV(arg1));
                BoolExpr out2 = z3context.mkBVUGE(Z3BitvectorFormulaManager.toBV(arg0), Z3BitvectorFormulaManager.toBV(arg1));
                return ImmutableList.of((Object)out1, (Object)out2);
            }
            if (sortKind == Z3_sort_kind.Z3_INT_SORT || sortKind == Z3_sort_kind.Z3_REAL_SORT) {
                BoolExpr out1 = z3context.mkLe(Z3NumeralFormulaManager.toAE(arg0), Z3NumeralFormulaManager.toAE(arg1));
                BoolExpr out2 = z3context.mkGe(Z3NumeralFormulaManager.toAE(arg0), Z3NumeralFormulaManager.toAE(arg1));
                return ImmutableList.of((Object)out1, (Object)out2);
            }
        }
        return ImmutableList.of((Object)pF);
    }

    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.substituteUsingLists(pF, pFromToMapping);
    }

    @Override
    protected Expr substituteUsingListsImpl(Expr t, List<Expr> changeFrom, List<Expr> changeTo) {
        int size = changeFrom.size();
        Preconditions.checkState((size == changeTo.size() ? 1 : 0) != 0);
        return t.substitute(changeFrom.toArray(new Expr[changeFrom.size()]), changeTo.toArray(new Expr[changeTo.size()]));
    }

    @Override
    public BooleanFormula translate(BooleanFormula other, SolverContext otherContext) {
        if (otherContext instanceof Z3SolverContext) {
            Z3SolverContext o = (Z3SolverContext)otherContext;
            Context otherZ3Context = (Context)o.getFormulaManager().getEnvironment();
            if (otherZ3Context == this.getEnvironment()) {
                return other;
            }
            Expr translatedAST = ((Expr)this.extractInfo(other)).translate((Context)this.getEnvironment());
            return this.getFormulaCreator().encapsulateBoolean(translatedAST);
        }
        return super.translate(other, otherContext);
    }
}

