/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Sort;
import java.util.Collection;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

class Z3BooleanFormulaManager
extends AbstractBooleanFormulaManager<Expr, Sort, Context, FuncDecl> {
    private final Context z3context;

    Z3BooleanFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Context)creator.getEnv();
    }

    static BoolExpr toBool(Expr e) {
        return (BoolExpr)e;
    }

    static BoolExpr[] toBool(Collection<? extends Expr> e) {
        return e.toArray(new BoolExpr[e.size()]);
    }

    @Override
    protected Expr makeVariableImpl(String varName) {
        Sort type = (Sort)this.getFormulaCreator().getBoolType();
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Expr makeBooleanImpl(boolean pValue) {
        if (pValue) {
            return this.z3context.mkTrue();
        }
        return this.z3context.mkFalse();
    }

    @Override
    protected Expr not(Expr pParam) {
        return this.z3context.mkNot(Z3BooleanFormulaManager.toBool(pParam));
    }

    @Override
    protected Expr and(Expr pParam1, Expr pParam2) {
        return this.z3context.mkAnd(new BoolExpr[]{Z3BooleanFormulaManager.toBool(pParam1), Z3BooleanFormulaManager.toBool(pParam2)});
    }

    @Override
    protected Expr or(Expr pParam1, Expr pParam2) {
        return this.z3context.mkOr(new BoolExpr[]{Z3BooleanFormulaManager.toBool(pParam1), Z3BooleanFormulaManager.toBool(pParam2)});
    }

    @Override
    protected Expr orImpl(Collection<Expr> params) {
        return this.z3context.mkOr(Z3BooleanFormulaManager.toBool(params));
    }

    @Override
    protected Expr andImpl(Collection<Expr> params) {
        return this.z3context.mkAnd(Z3BooleanFormulaManager.toBool(params));
    }

    @Override
    protected Expr xor(Expr pParam1, Expr pParam2) {
        return this.z3context.mkXor(Z3BooleanFormulaManager.toBool(pParam1), Z3BooleanFormulaManager.toBool(pParam2));
    }

    @Override
    protected Expr equivalence(Expr pBits1, Expr pBits2) {
        return this.z3context.mkEq((Expr)Z3BooleanFormulaManager.toBool(pBits1), (Expr)Z3BooleanFormulaManager.toBool(pBits2));
    }

    @Override
    protected Expr implication(Expr pBits1, Expr pBits2) {
        return this.z3context.mkImplies(Z3BooleanFormulaManager.toBool(pBits1), Z3BooleanFormulaManager.toBool(pBits2));
    }

    @Override
    protected boolean isTrue(Expr pParam) {
        return Z3BooleanFormulaManager.toBool(pParam).isTrue();
    }

    @Override
    protected boolean isFalse(Expr pParam) {
        return Z3BooleanFormulaManager.toBool(pParam).isFalse();
    }

    @Override
    protected Expr ifThenElse(Expr pCond, Expr pF1, Expr pF2) {
        return this.z3context.mkITE(Z3BooleanFormulaManager.toBool(pCond), pF1, pF2);
    }
}

