/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.solver.basicimpl.AbstractUFManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;

class Z3UFManager
extends AbstractUFManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3UFManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long createUninterpretedFunctionCallImpl(Long funcDecl, List<Long> pArgs) {
        return Z3NativeApi.mk_app(this.z3context, (long)funcDecl, Longs.toArray(pArgs));
    }

    @Override
    protected Long declareUninterpretedFunctionImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long symbol = Z3NativeApi.mk_string_symbol(this.z3context, pName);
        long[] sorts = Longs.toArray(pArgTypes);
        long func = Z3NativeApi.mk_func_decl(this.z3context, symbol, sorts, returnType);
        Z3NativeApi.inc_ref(this.z3context, func);
        return func;
    }
}

