/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.z3.Z3AbstractProver;
import org.sosy_lab.solver.z3.Z3Formula;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;
import org.sosy_lab.solver.z3.Z3SolverException;

class Z3OptimizationProver
extends Z3AbstractProver<Void>
implements OptimizationProverEnvironment {
    private final FormulaManager mgr;
    private final RationalFormulaManager rfmgr;
    private final LogManager logger;
    private static final String Z3_INFINITY_REPRESENTATION = "oo";
    private final long z3optContext;

    Z3OptimizationProver(FormulaManager mgr, Z3FormulaCreator creator, ShutdownNotifier pShutdownNotifier, LogManager pLogger) {
        super(creator, pShutdownNotifier);
        this.mgr = mgr;
        this.rfmgr = mgr.getRationalFormulaManager();
        this.z3optContext = Z3NativeApi.mk_optimize(this.z3context);
        Z3NativeApi.optimize_inc_ref(this.z3context, this.z3optContext);
        this.logger = pLogger;
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long z3Constraint = this.creator.extractInfo(constraint);
        Z3NativeApi.optimize_assert(this.z3context, this.z3optContext, z3Constraint);
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Z3NativeApi.optimize_maximize(this.z3context, this.z3optContext, z3Objective.getFormulaInfo());
    }

    @Override
    public int minimize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Z3NativeApi.optimize_minimize(this.z3context, this.z3optContext, z3Objective.getFormulaInfo());
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            int status = Z3NativeApi.optimize_check(this.z3context, this.z3optContext);
            if (status == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status) {
                return OptimizationProverEnvironment.OptStatus.UNSAT;
            }
            if (status == Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status) {
                this.logger.log(Level.INFO, new Object[]{"Solver returned an unknown status, explanation: ", Z3NativeApi.optimize_get_reason_unknown(this.z3context, this.z3optContext)});
                return OptimizationProverEnvironment.OptStatus.UNDEF;
            }
            return OptimizationProverEnvironment.OptStatus.OPT;
        }
        catch (Z3SolverException e) {
            this.shutdownNotifier.shutdownIfNecessary();
            throw e;
        }
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3NativeApi.optimize_push(this.z3context, this.z3optContext);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3NativeApi.optimize_pop(this.z3context, this.z3optContext);
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.check() == OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long ast = Z3NativeApi.optimize_get_upper(this.z3context, this.z3optContext, handle);
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long ast = Z3NativeApi.optimize_get_lower(this.z3context, this.z3optContext, handle);
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    protected long getZ3Model() {
        return Z3NativeApi.optimize_get_model(this.z3context, this.z3optContext);
    }

    void setParam(String key, String value) {
        long keySymbol = Z3NativeApi.mk_string_symbol(this.z3context, key);
        long valueSymbol = Z3NativeApi.mk_string_symbol(this.z3context, value);
        long params = Z3NativeApi.mk_params(this.z3context);
        Z3NativeApi.params_set_symbol(this.z3context, params, keySymbol, valueSymbol);
        Z3NativeApi.optimize_set_params(this.z3context, this.z3optContext, params);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3NativeApi.optimize_dec_ref(this.z3context, this.z3optContext);
        this.closed = true;
    }

    private boolean isInfinity(long ast) {
        return Z3NativeApi.ast_to_string(this.z3context, ast).contains(Z3_INFINITY_REPRESENTATION);
    }

    private long replaceEpsilon(long ast, Rational newValue) {
        Z3Formula.Z3RationalFormula z = new Z3Formula.Z3RationalFormula(this.z3context, ast);
        Z3Formula epsFormula = (Z3Formula)((Object)((NumeralFormula.RationalFormula)this.rfmgr.makeVariable("epsilon")));
        Z3Formula out = this.mgr.substitute(z, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of((Object)epsFormula, this.rfmgr.makeNumber(newValue.toString())));
        return Z3NativeApi.simplify(this.z3context, out.getFormulaInfo());
    }

    private Rational rationalFromZ3AST(long ast) {
        return Rational.ofString((String)Z3NativeApi.get_numeral_string(this.z3context, ast));
    }

    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Z3NativeApi.optimize_to_string(this.z3context, this.z3optContext);
    }
}

