/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.z3.Z3NativeApi;

class Z3NativeApiHelpers {
    private Z3NativeApiHelpers() {
    }

    static long applyTactics(long z3context, Long pF, String ... pTactics) throws InterruptedException, SolverException {
        long overallResult = pF;
        for (String tactic : pTactics) {
            long tacticResult = Z3NativeApiHelpers.applyTactic(z3context, overallResult, tactic);
            if (overallResult != pF) {
                Z3NativeApi.dec_ref(z3context, overallResult);
            }
            overallResult = tacticResult;
        }
        return overallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long applyTactic(long z3context, long pF, String tactic) throws InterruptedException {
        long tseitinTactic = Z3NativeApi.mk_tactic(z3context, tactic);
        Z3NativeApi.tactic_inc_ref(z3context, tseitinTactic);
        long goal = Z3NativeApi.mk_goal(z3context, true, false, false);
        Z3NativeApi.goal_inc_ref(z3context, goal);
        Z3NativeApi.goal_assert(z3context, goal, pF);
        long result = Z3NativeApi.tactic_apply(z3context, tseitinTactic, goal);
        Z3NativeApi.apply_result_inc_ref(z3context, result);
        try {
            long l = Z3NativeApiHelpers.applyResultToAST(z3context, result);
            return l;
        }
        finally {
            Z3NativeApi.apply_result_dec_ref(z3context, result);
            Z3NativeApi.goal_dec_ref(z3context, goal);
            Z3NativeApi.tactic_dec_ref(z3context, tseitinTactic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long applyResultToAST(long z3context, long applyResult) {
        int subgoalsCount = Z3NativeApi.apply_result_get_num_subgoals(z3context, applyResult);
        long[] goalFormulas = new long[subgoalsCount];
        for (int i = 0; i < subgoalsCount; ++i) {
            long subgoal = Z3NativeApi.apply_result_get_subgoal(z3context, applyResult, i);
            Z3NativeApi.goal_inc_ref(z3context, subgoal);
            long subgoalAst = Z3NativeApiHelpers.goalToAST(z3context, subgoal);
            Z3NativeApi.inc_ref(z3context, subgoalAst);
            goalFormulas[i] = subgoalAst;
            Z3NativeApi.goal_dec_ref(z3context, subgoal);
        }
        try {
            long l = goalFormulas.length == 1 ? goalFormulas[0] : Z3NativeApi.mk_or(z3context, goalFormulas.length, goalFormulas);
            return l;
        }
        finally {
            for (int i = 0; i < subgoalsCount; ++i) {
                Z3NativeApi.dec_ref(z3context, goalFormulas[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long goalToAST(long z3context, long goal) {
        int subgoalFormulasCount = Z3NativeApi.goal_size(z3context, goal);
        long[] subgoalFormulas = new long[subgoalFormulasCount];
        for (int k = 0; k < subgoalFormulasCount; ++k) {
            long f = Z3NativeApi.goal_formula(z3context, goal, k);
            Z3NativeApi.inc_ref(z3context, f);
            subgoalFormulas[k] = f;
        }
        try {
            long l = subgoalFormulas.length == 1 ? subgoalFormulas[0] : Z3NativeApi.mk_and(z3context, subgoalFormulas.length, subgoalFormulas);
            return l;
        }
        finally {
            for (int k = 0; k < subgoalFormulasCount; ++k) {
                Z3NativeApi.dec_ref(z3context, subgoalFormulas[k]);
            }
        }
    }
}

