/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.z3.Z3AbstractProver;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;
import org.sosy_lab.solver.z3.Z3SolverException;

class Z3InterpolatingProver
extends Z3AbstractProver<Long>
implements InterpolatingProverEnvironment<Long> {
    private final long z3solver;
    private int level = 0;
    private final Deque<Long> assertedFormulas = new ArrayDeque<Long>();

    Z3InterpolatingProver(Z3FormulaCreator creator, long z3params, ShutdownNotifier pShutdownNotifier) {
        super(creator, pShutdownNotifier);
        this.z3solver = Z3NativeApi.mk_solver(this.z3context);
        Z3NativeApi.solver_inc_ref(this.z3context, this.z3solver);
        Z3NativeApi.solver_set_params(this.z3context, this.z3solver, z3params);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Z3NativeApi.solver_get_num_scopes(this.z3context, this.z3solver) >= 1 ? 1 : 0) != 0);
        --this.level;
        this.assertedFormulas.removeLast();
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
    }

    @Override
    public Long addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = this.creator.extractInfo(f);
        Z3NativeApi.inc_ref(this.z3context, e);
        Z3NativeApi.solver_assert(this.z3context, this.z3solver, e);
        this.assertedFormulas.addLast(e);
        Z3NativeApi.dec_ref(this.z3context, e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int result = Z3NativeApi.solver_check(this.z3context, this.z3solver);
        this.shutdownNotifier.shutdownIfNecessary();
        Preconditions.checkState((result != Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status ? 1 : 0) != 0);
        return result == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status;
    }

    @Override
    public BooleanFormula getInterpolant(List<Long> formulasOfA) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LinkedList formulasOfB = Lists.newLinkedList(this.assertedFormulas);
        for (long af : formulasOfA) {
            boolean check = formulasOfB.remove(af);
            assert (check) : "formula from A must be part of all asserted formulas";
        }
        return (BooleanFormula)Iterables.getOnlyElement(this.getSeqInterpolants((List<Set<Long>>)ImmutableList.of((Object)Sets.newHashSet(formulasOfA), (Object)Sets.newHashSet((Iterable)formulasOfB))));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Long>> partitionedFormulas) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionedFormulas.size() >= 2 ? 1 : 0) != 0, (Object)"at least 2 partitions needed for interpolation");
        return this.getTreeInterpolants(partitionedFormulas, new int[partitionedFormulas.size()]);
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Long>> partitionedFormulas, int[] startOfSubTree) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] conjunctionFormulas = new long[partitionedFormulas.size()];
        for (int i = 0; i < partitionedFormulas.size(); ++i) {
            Preconditions.checkState((!partitionedFormulas.get(i).isEmpty() ? 1 : 0) != 0);
            long conjunction = Z3NativeApi.mk_and(this.z3context, Longs.toArray((Collection)partitionedFormulas.get(i)));
            Z3NativeApi.inc_ref(this.z3context, conjunction);
            conjunctionFormulas[i] = conjunction;
        }
        long[] interpolationFormulas = new long[partitionedFormulas.size()];
        ArrayDeque<Z3TreeInterpolant> stack = new ArrayDeque<Z3TreeInterpolant>();
        int lastSubtree = -1;
        for (int i = 0; i < startOfSubTree.length; ++i) {
            long interpolationPoint;
            long conjunction;
            int currentSubtree = startOfSubTree[i];
            if (currentSubtree > lastSubtree) {
                conjunction = conjunctionFormulas[i];
            } else {
                ArrayList<Long> children = new ArrayList<Long>();
                while (!stack.isEmpty() && currentSubtree <= ((Z3TreeInterpolant)stack.peekLast()).getRootOfTree()) {
                    children.add(0, ((Z3TreeInterpolant)stack.pollLast()).getInterpolationPoint());
                }
                children.add(conjunctionFormulas[i]);
                conjunction = Z3NativeApi.mk_and(this.z3context, Longs.toArray(children));
            }
            if (i == startOfSubTree.length - 1) {
                interpolationPoint = conjunction;
                Preconditions.checkState((currentSubtree == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
                Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should be the last element in the stack.");
            } else {
                interpolationPoint = Z3NativeApi.mk_interpolant(this.z3context, conjunction);
            }
            Z3NativeApi.inc_ref(this.z3context, interpolationPoint);
            interpolationFormulas[i] = interpolationPoint;
            stack.addLast(new Z3TreeInterpolant(currentSubtree, interpolationPoint));
            lastSubtree = currentSubtree;
        }
        Preconditions.checkState((((Z3TreeInterpolant)stack.peekLast()).getRootOfTree() == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
        long root = ((Z3TreeInterpolant)stack.pollLast()).getInterpolationPoint();
        Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should have been the last element in the stack.");
        long proof = Z3NativeApi.solver_get_proof(this.z3context, this.z3solver);
        Z3NativeApi.inc_ref(this.z3context, proof);
        long interpolationResult = Z3NativeApi.get_interpolant(this.z3context, proof, root, Z3NativeApi.mk_params(this.z3context));
        this.shutdownNotifier.shutdownIfNecessary();
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (int i = 0; i < partitionedFormulas.size() - 1; ++i) {
            result.add(this.creator.encapsulateBoolean(Z3NativeApi.ast_vector_get(this.z3context, interpolationResult, i)));
        }
        Z3NativeApi.dec_ref(this.z3context, proof);
        for (long partition : conjunctionFormulas) {
            Z3NativeApi.dec_ref(this.z3context, partition);
        }
        for (long partition : interpolationFormulas) {
            Z3NativeApi.dec_ref(this.z3context, partition);
        }
        return result;
    }

    @Override
    protected long getZ3Model() {
        return Z3NativeApi.solver_get_model(this.z3context, this.z3solver);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        while (this.level > 0) {
            this.pop();
        }
        this.assertedFormulas.clear();
        Z3NativeApi.solver_dec_ref(this.z3context, this.z3solver);
        this.closed = true;
    }

    private static class Z3TreeInterpolant {
        private final int rootOfSubTree;
        private final long interpolationPoint;

        private Z3TreeInterpolant(int pRootOfSubtree, long pInterpolationPoint) {
            this.rootOfSubTree = pRootOfSubtree;
            this.interpolationPoint = pInterpolationPoint;
        }

        private int getRootOfTree() {
            return this.rootOfSubTree;
        }

        private long getInterpolationPoint() {
            return this.interpolationPoint;
        }
    }
}

