/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import java.math.BigDecimal;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NumeralFormulaManager;

class Z3IntegerFormulaManager
extends Z3NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Z3IntegerFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    public FormulaType<NumeralFormula.IntegerFormula> getFormulaType() {
        return FormulaType.IntegerType;
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return (Long)this.decimalAsInteger(pNumber);
    }

    @Override
    public Long modulo(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_mod(this.z3context, pNumber1, pNumber2);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        if (pModulo > 0L) {
            long n = this.makeNumberImpl(pModulo);
            long x = this.subtract(pNumber1, pNumber2);
            return Z3NativeApi.mk_eq(this.z3context, x, Z3NativeApi.mk_mul(this.z3context, n, Z3NativeApi.mk_div(this.z3context, x, n)));
        }
        return Z3NativeApi.mk_true(this.z3context);
    }
}

