/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Longs;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.z3.Z3Formula;
import org.sosy_lab.solver.z3.Z3FormulaManager;
import org.sosy_lab.solver.z3.Z3Model;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;

@Options(prefix="solver.z3")
class Z3FormulaCreator
extends FormulaCreator<Long, Long, Long, Long> {
    @Option(secure=true, description="Whether to use PhantomReferences for discarding Z3 AST")
    private boolean usePhantomReferences = false;
    private final Table<Long, Long, Long> allocatedArraySorts = HashBasedTable.create();
    private final ReferenceQueue<Z3Formula> referenceQueue = new ReferenceQueue();
    private final Map<PhantomReference<? extends Z3Formula>, Long> referenceMap = Maps.newIdentityHashMap();
    private final ReferenceQueue<Z3Model> modelReferenceQueue = new ReferenceQueue();
    private final Map<PhantomReference<? extends Z3Model>, Long> modelReferenceMap = Maps.newIdentityHashMap();
    private final Timer cleanupTimer = new Timer();

    Z3FormulaCreator(long pEnv, long pBoolType, long pIntegerType, long pRealType, Configuration config) throws InvalidConfigurationException {
        super(pEnv, pBoolType, pIntegerType, pRealType);
        config.inject((Object)this);
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long z3context = (Long)this.getEnv();
        long symbol = Z3NativeApi.mk_string_symbol(z3context, varName);
        return Z3NativeApi.mk_const(z3context, symbol, type);
    }

    @Override
    public Long extractInfo(Formula pT) {
        return Z3FormulaManager.getZ3Expr(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula || pFormula instanceof BitvectorFormula) {
            long term = this.extractInfo(pFormula);
            return this.getFormulaType(term);
        }
        return super.getFormulaType(pFormula);
    }

    public FormulaType<?> getFormulaTypeFromSort(Long pSort) {
        long z3context = (Long)this.getEnv();
        long sortKind = Z3NativeApi.get_sort_kind(z3context, pSort);
        if (sortKind == 1L) {
            return FormulaType.BooleanType;
        }
        if (sortKind == 2L) {
            return FormulaType.IntegerType;
        }
        if (sortKind == 5L) {
            long domainSort = Z3NativeApi.get_array_sort_domain(z3context, pSort);
            long rangeSort = Z3NativeApi.get_array_sort_range(z3context, pSort);
            return FormulaType.getArrayType(this.getFormulaTypeFromSort(domainSort), this.getFormulaTypeFromSort(rangeSort));
        }
        if (sortKind == 3L) {
            return FormulaType.RationalType;
        }
        if (sortKind == 4L) {
            return FormulaType.getBitvectorTypeWithSize(Z3NativeApi.get_bv_sort_size(z3context, pSort));
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long sort = Z3NativeApi.get_sort((Long)this.getEnv(), pFormula);
        return this.getFormulaTypeFromSort(sort);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getIndexType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> ArrayFormula<TD, TR> encapsulateArray(Long pTerm, FormulaType<TD> pIndexType, FormulaType<TR> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType)));
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3ArrayFormula<TD, TR>((Long)this.getEnv(), pTerm, pIndexType, pElementType), pTerm);
    }

    private <T extends Z3Formula> T storePhantomReference(T out, Long pTerm) {
        if (this.usePhantomReferences) {
            PhantomReference<Z3Formula> ref = new PhantomReference<Z3Formula>(out, this.referenceQueue);
            this.referenceMap.put(ref, pTerm);
        }
        return out;
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        this.cleanupReferences();
        if (pType.isBooleanType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3IntegerFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isRationalType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3RationalFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)this.storePhantomReference(new Z3Formula.Z3ArrayFormula((Long)this.getEnv(), pTerm, arrFt.getIndexType(), arrFt.getElementType()), pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Z3");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        Long allocatedArraySort = (Long)this.allocatedArraySorts.get((Object)pIndexType, (Object)pElementType);
        if (allocatedArraySort == null) {
            allocatedArraySort = Z3NativeApi.mk_array_sort((Long)this.getEnv(), pIndexType, pElementType);
            Z3NativeApi.inc_ref((Long)this.getEnv(), allocatedArraySort);
            this.allocatedArraySorts.put((Object)pIndexType, (Object)pElementType, (Object)allocatedArraySort);
        }
        return allocatedArraySort;
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        Preconditions.checkArgument((pBitwidth > 0 ? 1 : 0) != 0, (String)"Cannot use bitvector type with size %s", (Object[])new Object[]{pBitwidth});
        long bvSort = Z3NativeApi.mk_bv_sort((Long)this.getEnv(), pBitwidth);
        Z3NativeApi.inc_ref((Long)this.getEnv(), Z3NativeApi.sort_to_ast((Long)this.getEnv(), bvSort));
        return bvSort;
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Z3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        if (!this.usePhantomReferences) {
            return;
        }
        this.cleanupTimer.start();
        try {
            Reference<Z3Formula> ref;
            while ((ref = this.referenceQueue.poll()) != null) {
                long z3ast = this.referenceMap.remove(ref);
                Z3NativeApi.dec_ref((Long)this.environment, z3ast);
            }
        }
        finally {
            this.cleanupTimer.stop();
        }
    }

    void storeModelPhantomReference(Z3Model model, long nativeModel) {
        PhantomReference<Z3Model> ref = new PhantomReference<Z3Model>(model, this.modelReferenceQueue);
        this.modelReferenceMap.put(ref, nativeModel);
    }

    void cleanupModelReferences() {
        Reference<Z3Model> ref;
        this.cleanupTimer.start();
        while ((ref = this.modelReferenceQueue.poll()) != null) {
            long z3model = this.modelReferenceMap.remove(ref);
            Z3NativeApi.model_dec_ref((Long)this.environment, z3model);
        }
        this.cleanupTimer.stop();
    }

    private Long replaceArgs(Long t, List<Long> newArgs) {
        Preconditions.checkState((Z3NativeApi.get_app_num_args((Long)this.environment, t) == newArgs.size() ? 1 : 0) != 0);
        long[] newParams = Longs.toArray(newArgs);
        long funcDecl = Z3NativeApi.get_app_decl((Long)this.environment, t);
        return Z3NativeApi.mk_app((long)((Long)this.environment), funcDecl, newParams);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Long f) {
        switch (Z3NativeApi.get_ast_kind((Long)this.environment, f)) {
            case 0: {
                return visitor.visitConstant(formula, this.convertValue(f));
            }
            case 1: {
                long funcDecl = Z3NativeApi.get_app_decl((Long)this.environment, f);
                long symbol = Z3NativeApi.get_decl_name((Long)this.environment, funcDecl);
                assert (Z3NativeApi.get_symbol_kind((Long)this.environment, symbol) == 1);
                String name = Z3NativeApi.get_symbol_string((Long)this.environment, symbol);
                int arity = Z3NativeApi.get_app_num_args((Long)this.environment, f);
                if (arity == 0) {
                    long declKind = Z3NativeApi.get_decl_kind((Long)this.environment, Z3NativeApi.get_app_decl((Long)this.environment, f));
                    if (declKind == 256L || declKind == 257L) {
                        return visitor.visitConstant(formula, declKind == 256L);
                    }
                    return visitor.visitFreeVariable(formula, name);
                }
                ImmutableList.Builder args = ImmutableList.builder();
                ImmutableList.Builder argTypes = ImmutableList.builder();
                for (int i = 0; i < arity; ++i) {
                    long arg = Z3NativeApi.get_app_arg((Long)this.environment, f, i);
                    FormulaType<?> argumentType = this.getFormulaType(arg);
                    args.add(this.encapsulate(argumentType, arg));
                    argTypes.add(argumentType);
                }
                return visitor.visitFunction(formula, (List<Formula>)args.build(), FunctionDeclarationImpl.of(name, this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), funcDecl));
            }
            case 2: {
                int deBruijnIdx = Z3NativeApi.get_index_value((Long)this.environment, f);
                return visitor.visitBoundVariable(formula, deBruijnIdx);
            }
            case 3: {
                BooleanFormula body = this.encapsulateBoolean(Z3NativeApi.get_quantifier_body((Long)this.environment, f));
                QuantifiedFormulaManager.Quantifier q = Z3NativeApi.is_quantifier_forall((Long)this.environment, f) ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS;
                return visitor.visitQuantifier((BooleanFormula)formula, q, this.getBoundVars(f), body);
            }
        }
        throw new UnsupportedOperationException("Input should be a formula AST, got unexpected type instead");
    }

    private List<Formula> getBoundVars(long f) {
        int numBound = Z3NativeApi.get_quantifier_num_bound((Long)this.environment, f);
        ArrayList<Formula> boundVars = new ArrayList<Formula>(numBound);
        for (int i = 0; i < numBound; ++i) {
            long varName = Z3NativeApi.get_quantifier_bound_name((Long)this.environment, f, i);
            long varSort = Z3NativeApi.get_quantifier_bound_sort((Long)this.environment, f, i);
            boundVars.add((Formula)this.encapsulate(this.getFormulaTypeFromSort(varSort), Z3NativeApi.mk_const((Long)this.environment, varName, varSort)));
        }
        return boundVars;
    }

    private FunctionDeclarationKind getDeclarationKind(long f) {
        int decl = Z3NativeApi.get_decl_kind((Long)this.environment, Z3NativeApi.get_app_decl((Long)this.environment, f));
        assert (Z3NativeApi.get_arity((Long)this.environment, Z3NativeApi.get_app_decl((Long)this.environment, f)) > 0) : "Variables should be handled somewhere else.";
        switch (decl) {
            case 261: {
                return FunctionDeclarationKind.AND;
            }
            case 265: {
                return FunctionDeclarationKind.NOT;
            }
            case 262: {
                return FunctionDeclarationKind.OR;
            }
            case 263: {
                return FunctionDeclarationKind.IFF;
            }
            case 260: {
                return FunctionDeclarationKind.ITE;
            }
            case 264: {
                return FunctionDeclarationKind.XOR;
            }
            case 259: {
                return FunctionDeclarationKind.DISTINCT;
            }
            case 266: {
                return FunctionDeclarationKind.IMPLIES;
            }
            case 519: {
                return FunctionDeclarationKind.SUB;
            }
            case 518: {
                return FunctionDeclarationKind.ADD;
            }
            case 522: {
                return FunctionDeclarationKind.DIV;
            }
            case 521: {
                return FunctionDeclarationKind.MUL;
            }
            case 525: {
                return FunctionDeclarationKind.MODULO;
            }
            case 2349: {
                return FunctionDeclarationKind.UF;
            }
            case 516: {
                return FunctionDeclarationKind.LT;
            }
            case 514: {
                return FunctionDeclarationKind.LTE;
            }
            case 517: {
                return FunctionDeclarationKind.GT;
            }
            case 515: {
                return FunctionDeclarationKind.GTE;
            }
            case 258: {
                return FunctionDeclarationKind.EQ;
            }
            case 768: {
                return FunctionDeclarationKind.STORE;
            }
            case 769: {
                return FunctionDeclarationKind.SELECT;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertValue(Long value) {
        Z3NativeApi.inc_ref((Long)this.environment, value);
        try {
            FormulaType<?> type = this.getFormulaType(value);
            if (type.isBooleanType()) {
                Boolean bl = Z3NativeApiConstants.isOP((Long)this.environment, value, 256);
                return bl;
            }
            if (type.isIntegerType()) {
                BigInteger bigInteger = new BigInteger(Z3NativeApi.get_numeral_string((Long)this.environment, value));
                return bigInteger;
            }
            if (type.isRationalType()) {
                Rational rational = Rational.ofString((String)Z3NativeApi.get_numeral_string((Long)this.environment, value));
                return rational;
            }
            if (type.isBitvectorType()) {
                BigInteger bigInteger = new BigInteger(Z3NativeApi.get_numeral_string((Long)this.environment, value));
                return bigInteger;
            }
            String string = Z3NativeApi.ast_to_string((Long)this.environment, value);
            return string;
        }
        finally {
            Z3NativeApi.dec_ref((Long)this.environment, value);
        }
    }

    @Override
    public Long callFunctionImpl(FunctionDeclarationImpl<?, Long> declaration, List<Long> args) {
        return Z3NativeApi.mk_app((long)((Long)this.environment), (long)declaration.getSolverDeclaration(), Longs.toArray(args));
    }

    @Override
    protected Long getBooleanVarDeclarationImpl(Long pLong) {
        return Z3NativeApi.get_app_decl((Long)this.getEnv(), pLong);
    }
}

