/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3Model;

abstract class Z3AbstractProver<T>
implements BasicProverEnvironment<T> {
    protected final Z3FormulaCreator creator;
    protected final long z3context;
    protected boolean closed = false;
    protected final ShutdownNotifier shutdownNotifier;

    protected Z3AbstractProver(Z3FormulaCreator creator, ShutdownNotifier pShutdownNotifier) {
        this.creator = creator;
        this.z3context = (Long)creator.getEnv();
        this.shutdownNotifier = pShutdownNotifier;
    }

    protected abstract long getZ3Model();

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Z3Model.create(this.z3context, this.getZ3Model(), this.creator);
    }

    @Override
    public T push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        return this.addConstraint(f);
    }
}

