/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Collection;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverTheoriesTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void basicBoolTest() throws Exception {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeBoolean(false);
        BooleanFormula c = this.bmgr.xor(a, b);
        BooleanFormula d = this.bmgr.makeVariable("b");
        BooleanFormula e = this.bmgr.xor(a, d);
        BooleanFormula notImpl = this.bmgr.and(a, this.bmgr.not(e));
        this.assertThatFormula(a).implies(c);
        this.assertThatFormula(notImpl).isSatisfiable();
    }

    @Test
    public void basicIntTest() {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        Truth.assertThat((Object)a).isNotEqualTo((Object)b);
    }

    @Test
    public void basisRatTest() throws Exception {
        this.requireRationals();
        NumeralFormula.RationalFormula a = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("int_c");
        NumeralFormula.RationalFormula num = (NumeralFormula.RationalFormula)this.rmgr.makeNumber(4L);
        BooleanFormula f = this.rmgr.equal(this.rmgr.add(a, a), num);
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void intTest1() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula f = this.imgr.equal(this.imgr.add(a, a), num);
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void intTest2() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        BooleanFormula f = this.imgr.equal(this.imgr.add(a, a), num);
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void intTest3_DivModLinear() throws Exception {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the operations MOD and DIV").that(Boolean.valueOf(this.solver == SolverContextFactory.Solvers.MATHSAT5)).isFalse();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula num10 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L);
        NumeralFormula.IntegerFormula num5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula num3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula num2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula num1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula num0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        BooleanFormula fa = this.imgr.equal(a, num10);
        BooleanFormula fb = this.imgr.equal(b, num2);
        BooleanFormula fADiv5 = this.imgr.equal(this.imgr.divide(a, num5), b);
        BooleanFormula fADiv3 = this.imgr.equal(this.imgr.divide(a, num3), num3);
        BooleanFormula fAMod5 = this.imgr.equal(this.imgr.modulo(a, num5), num0);
        BooleanFormula fAMod3 = this.imgr.equal(this.imgr.modulo(a, num3), num1);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod3)}))).isUnsatisfiable();
    }

    @Test
    public void intTest3_DivModNonLinear() throws Exception {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the operations MOD and DIV").that(Boolean.valueOf(this.solver != SolverContextFactory.Solvers.MATHSAT5 && this.solver != SolverContextFactory.Solvers.SMTINTERPOL)).isTrue();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula num10 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L);
        NumeralFormula.IntegerFormula num5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula num2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula fa = this.imgr.equal(a, num10);
        BooleanFormula fb = this.imgr.equal(b, num2);
        BooleanFormula fADivB = this.imgr.equal(this.imgr.divide(a, b), num5);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivB}))).isSatisfiable();
    }

    @Test
    public void intTest3_DivMod_NegativeNumbersLinear() throws Exception {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the operations MOD and DIV").that(Boolean.valueOf(this.solver == SolverContextFactory.Solvers.MATHSAT5)).isFalse();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula numNeg10 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-10L);
        NumeralFormula.IntegerFormula num5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula num4 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        NumeralFormula.IntegerFormula numNeg4 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-4L);
        NumeralFormula.IntegerFormula num3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula numNeg3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-3L);
        NumeralFormula.IntegerFormula numNeg2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-2L);
        NumeralFormula.IntegerFormula num2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula num0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        BooleanFormula fa = this.imgr.equal(a, numNeg10);
        BooleanFormula fb = this.imgr.equal(b, numNeg2);
        BooleanFormula fADiv5 = this.imgr.equal(this.imgr.divide(a, num5), b);
        BooleanFormula fADiv3 = this.imgr.equal(this.imgr.divide(a, num3), numNeg4);
        BooleanFormula fADivNeg3 = this.imgr.equal(this.imgr.divide(a, numNeg3), num4);
        BooleanFormula fAMod5 = this.imgr.equal(this.imgr.modulo(a, num5), num0);
        BooleanFormula fAMod3 = this.imgr.equal(this.imgr.modulo(a, num3), num2);
        BooleanFormula fAModNeg3 = this.imgr.equal(this.imgr.modulo(a, numNeg3), num2);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivNeg3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADivNeg3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAModNeg3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAModNeg3)}))).isUnsatisfiable();
    }

    @Test
    public void intTest3_DivMod_NegativeNumbersNonLinear() throws Exception {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the operations MOD and DIV").that(Boolean.valueOf(this.solver != SolverContextFactory.Solvers.MATHSAT5 && this.solver != SolverContextFactory.Solvers.SMTINTERPOL)).isTrue();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula numNeg10 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-10L);
        NumeralFormula.IntegerFormula num5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula numNeg2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-2L);
        BooleanFormula fa = this.imgr.equal(a, numNeg10);
        BooleanFormula fb = this.imgr.equal(b, numNeg2);
        BooleanFormula fADivB = this.imgr.equal(this.imgr.divide(a, b), num5);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivB}))).isSatisfiable();
    }

    @Test
    public void intTestBV_DivMod() throws Exception {
        this.requireBitvectors();
        BitvectorFormula a = this.bvmgr.makeVariable(32, "int_a");
        BitvectorFormula b = this.bvmgr.makeVariable(32, "int_b");
        BitvectorFormula num10 = this.bvmgr.makeBitvector(32, 10L);
        BitvectorFormula num5 = this.bvmgr.makeBitvector(32, 5L);
        BitvectorFormula num3 = this.bvmgr.makeBitvector(32, 3L);
        BitvectorFormula num2 = this.bvmgr.makeBitvector(32, 2L);
        BitvectorFormula num1 = this.bvmgr.makeBitvector(32, 1L);
        BitvectorFormula num0 = this.bvmgr.makeBitvector(32, 0L);
        BooleanFormula fa = this.bvmgr.equal(a, num10);
        BooleanFormula fb = this.bvmgr.equal(b, num2);
        BooleanFormula fADiv5 = this.bvmgr.equal(this.bvmgr.divide(a, num5, true), b);
        BooleanFormula fADiv3 = this.bvmgr.equal(this.bvmgr.divide(a, num3, true), num3);
        BooleanFormula fADivB = this.bvmgr.equal(this.bvmgr.divide(a, b, true), num5);
        BooleanFormula fAMod5 = this.bvmgr.equal(this.bvmgr.modulo(a, num5, true), num0);
        BooleanFormula fAMod3 = this.bvmgr.equal(this.bvmgr.modulo(a, num3, true), num1);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivB}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADivB)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod3)}))).isUnsatisfiable();
    }

    @Test
    public void intTestBV_DivMod_NegativeNumbers() throws Exception {
        this.requireBitvectors();
        BitvectorFormula a = this.bvmgr.makeVariable(32, "int_a");
        BitvectorFormula b = this.bvmgr.makeVariable(32, "int_b");
        BitvectorFormula numNeg10 = this.bvmgr.makeBitvector(32, -10L);
        BitvectorFormula num5 = this.bvmgr.makeBitvector(32, 5L);
        BitvectorFormula num3 = this.bvmgr.makeBitvector(32, 3L);
        BitvectorFormula numNeg3 = this.bvmgr.makeBitvector(32, -3L);
        BitvectorFormula numNeg2 = this.bvmgr.makeBitvector(32, -2L);
        BitvectorFormula numNeg1 = this.bvmgr.makeBitvector(32, -1L);
        BitvectorFormula num0 = this.bvmgr.makeBitvector(32, 0L);
        BooleanFormula fa = this.bvmgr.equal(a, numNeg10);
        BooleanFormula fb = this.bvmgr.equal(b, numNeg2);
        BooleanFormula fADiv5 = this.bvmgr.equal(this.bvmgr.divide(a, num5, true), b);
        BooleanFormula fADiv3 = this.bvmgr.equal(this.bvmgr.divide(a, num3, true), numNeg3);
        BooleanFormula fADivNeg3 = this.bvmgr.equal(this.bvmgr.divide(a, numNeg3, true), num3);
        BooleanFormula fADivB = this.bvmgr.equal(this.bvmgr.divide(a, b, true), num5);
        BooleanFormula fAMod5 = this.bvmgr.equal(this.bvmgr.modulo(a, num5, true), num0);
        BooleanFormula fAMod3 = this.bvmgr.equal(this.bvmgr.modulo(a, num3, true), numNeg1);
        BooleanFormula fAModNeg3 = this.bvmgr.equal(this.bvmgr.modulo(a, numNeg3, true), numNeg1);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADiv3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADiv3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivNeg3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADivNeg3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fADivB}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fADivB)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAMod3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAMod3)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fAModNeg3}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, this.bmgr.not(fAModNeg3)}))).isUnsatisfiable();
    }

    @Test
    public void intTest4_ModularCongruence_Simple() throws Exception {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        BooleanFormula f1 = this.imgr.modularCongruence(x, this.imgr.makeNumber(0L), 2L);
        BooleanFormula f2 = this.imgr.equal(x, this.imgr.makeNumber(1L));
        this.assertThatFormula(this.bmgr.and(f1, f2)).isUnsatisfiable();
    }

    @Test
    public void intTest4_ModularCongruence() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_c");
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_d");
        NumeralFormula.IntegerFormula num10 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L);
        NumeralFormula.IntegerFormula num5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula num0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula numNeg5 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-5L);
        BooleanFormula fa = this.imgr.equal(a, num10);
        BooleanFormula fb = this.imgr.equal(b, num5);
        BooleanFormula fc = this.imgr.equal(c, num0);
        BooleanFormula fd = this.imgr.equal(d, numNeg5);
        BooleanFormula fConb5 = this.imgr.modularCongruence(a, b, 5L);
        BooleanFormula fConc5 = this.imgr.modularCongruence(a, c, 5L);
        BooleanFormula fCond5 = this.imgr.modularCongruence(a, d, 5L);
        BooleanFormula fConb7 = this.imgr.modularCongruence(a, b, 7L);
        BooleanFormula fConc7 = this.imgr.modularCongruence(a, c, 7L);
        BooleanFormula fCond7 = this.imgr.modularCongruence(a, d, 7L);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fConb5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fConb5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, fConc5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, this.bmgr.not(fConc5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, fCond5}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, this.bmgr.not(fCond5)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fConb7}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fConb7)}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, fConc7}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, this.bmgr.not(fConc7)}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, fCond7}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, this.bmgr.not(fCond7)}))).isSatisfiable();
    }

    @Test
    public void intTest4_ModularCongruence_NegativeNumbers() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_c");
        NumeralFormula.IntegerFormula num8 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(8L);
        NumeralFormula.IntegerFormula num3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula numNeg2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-2L);
        BooleanFormula fa = this.imgr.equal(a, num8);
        BooleanFormula fb = this.imgr.equal(b, num3);
        BooleanFormula fc = this.imgr.equal(c, numNeg2);
        BooleanFormula fConb = this.imgr.modularCongruence(a, b, 5L);
        BooleanFormula fConc = this.imgr.modularCongruence(a, c, 5L);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fConb}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fConb)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, fConc}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, this.bmgr.not(fConc)}))).isUnsatisfiable();
    }

    @Test
    public void intTestBV_ModularCongruence() throws Exception {
        this.requireBitvectors();
        BitvectorFormula a = this.bvmgr.makeVariable(32, "int_a");
        BitvectorFormula b = this.bvmgr.makeVariable(32, "int_b");
        BitvectorFormula c = this.bvmgr.makeVariable(32, "int_c");
        BitvectorFormula d = this.bvmgr.makeVariable(32, "int_d");
        BitvectorFormula num10 = this.bvmgr.makeBitvector(32, 10L);
        BitvectorFormula num5 = this.bvmgr.makeBitvector(32, 5L);
        BitvectorFormula num0 = this.bvmgr.makeBitvector(32, 0L);
        BitvectorFormula numNeg5 = this.bvmgr.makeBitvector(32, -5L);
        BooleanFormula fa = this.bvmgr.equal(a, num10);
        BooleanFormula fb = this.bvmgr.equal(b, num5);
        BooleanFormula fc = this.bvmgr.equal(c, num0);
        BooleanFormula fd = this.bvmgr.equal(d, numNeg5);
        BooleanFormula fConb = this.bvmgr.modularCongruence(a, b, 5L);
        BooleanFormula fConc = this.bvmgr.modularCongruence(a, c, 5L);
        BooleanFormula fCond = this.bvmgr.modularCongruence(a, d, 5L);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fConb}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fConb)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, fConc}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, this.bmgr.not(fConc)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, fCond}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fd, this.bmgr.not(fCond)}))).isUnsatisfiable();
    }

    @Test
    public void intTestBV_ModularCongruence_NegativeNumbers() throws Exception {
        this.requireBitvectors();
        BitvectorFormula a = this.bvmgr.makeVariable(32, "int_a");
        BitvectorFormula b = this.bvmgr.makeVariable(32, "int_b");
        BitvectorFormula c = this.bvmgr.makeVariable(32, "int_c");
        BitvectorFormula num8 = this.bvmgr.makeBitvector(32, 8L);
        BitvectorFormula num3 = this.bvmgr.makeBitvector(32, 3L);
        BitvectorFormula numNeg2 = this.bvmgr.makeBitvector(32, -2L);
        BooleanFormula fa = this.bvmgr.equal(a, num8);
        BooleanFormula fb = this.bvmgr.equal(b, num3);
        BooleanFormula fc = this.bvmgr.equal(c, numNeg2);
        BooleanFormula fConb = this.bvmgr.modularCongruence(a, b, 5L);
        BooleanFormula fConc = this.bvmgr.modularCongruence(a, c, 5L);
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, fConb}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fb, this.bmgr.not(fConb)}))).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, fConc}))).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{fa, fc, this.bmgr.not(fConc)}))).isUnsatisfiable();
    }

    @Test
    public void realTest() throws Exception {
        this.requireRationals();
        NumeralFormula.RationalFormula a = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("int_c");
        NumeralFormula.RationalFormula num = (NumeralFormula.RationalFormula)this.rmgr.makeNumber(1L);
        BooleanFormula f = this.rmgr.equal(this.rmgr.add(a, a), num);
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void test_BitvectorIsZeroAfterShiftLeft() throws Exception {
        this.requireBitvectors();
        BitvectorFormula one = this.bvmgr.makeBitvector(32, 1L);
        BitvectorFormula a = this.bvmgr.makeVariable(8, "char_a");
        BitvectorFormula b = this.bvmgr.makeVariable(8, "char_b");
        BitvectorFormula rightOp = this.bvmgr.makeBitvector(32, 7L);
        a = this.bvmgr.extend(a, 24, false);
        b = this.bvmgr.extend(b, 24, false);
        a = this.bvmgr.or(a, one);
        b = this.bvmgr.or(b, one);
        a = this.bvmgr.extract(a, 7, 0, true);
        b = this.bvmgr.extract(b, 7, 0, true);
        a = this.bvmgr.extend(a, 24, false);
        b = this.bvmgr.extend(b, 24, false);
        a = this.bvmgr.shiftLeft(a, rightOp);
        b = this.bvmgr.shiftLeft(b, rightOp);
        a = this.bvmgr.extract(a, 7, 0, true);
        b = this.bvmgr.extract(b, 7, 0, true);
        BooleanFormula f = this.bmgr.not(this.bvmgr.equal(a, b));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testUfWithBoolType() throws SolverException, InterruptedException {
        FunctionDeclaration<BooleanFormula> uf = this.fmgr.declareUF("fun_ib", FormulaType.BooleanType, FormulaType.IntegerType);
        BooleanFormula uf0 = this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(0L)));
        BooleanFormula uf1 = this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(1L)));
        BooleanFormula uf2 = this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(2L)));
        BooleanFormula f01 = this.bmgr.xor(uf0, uf1);
        BooleanFormula f02 = this.bmgr.xor(uf0, uf2);
        BooleanFormula f12 = this.bmgr.xor(uf1, uf2);
        this.assertThatFormula(f01).isSatisfiable();
        this.assertThatFormula(f02).isSatisfiable();
        this.assertThatFormula(f12).isSatisfiable();
        BooleanFormula f = this.bmgr.and((Collection<BooleanFormula>)ImmutableList.of((Object)f01, (Object)f02, (Object)f12));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    @Ignore
    public void testUfWithBoolArg() throws SolverException, InterruptedException {
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf = this.fmgr.declareUF("fun_bi", FormulaType.IntegerType, FormulaType.BooleanType);
        NumeralFormula.IntegerFormula ufTrue = this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of((Object)this.bmgr.makeBoolean(true)));
        NumeralFormula.IntegerFormula ufFalse = this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of((Object)this.bmgr.makeBoolean(false)));
        BooleanFormula f = this.bmgr.not(this.imgr.equal(ufTrue, ufFalse));
        Truth.assertThat((String)f.toString()).isEmpty();
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUfWithBoolArg_unsupported() {
        this.fmgr.declareUF("fun_bi", FormulaType.IntegerType, FormulaType.BooleanType);
    }

    @Test
    public void quantifierEliminationTest1() throws Exception {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula var_B = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula var_C = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c");
        NumeralFormula.IntegerFormula num_2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula num_1000 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1000L);
        BooleanFormula eq_c_2 = this.imgr.equal(var_C, num_2);
        NumeralFormula.IntegerFormula minus_b_c = (NumeralFormula.IntegerFormula)this.imgr.subtract(var_B, var_C);
        BooleanFormula gt_bMinusC_1000 = this.imgr.greaterThan(minus_b_c, num_1000);
        BooleanFormula and_cEq2_bMinusCgt1000 = this.bmgr.and(eq_c_2, gt_bMinusC_1000);
        BooleanFormula f = this.qmgr.exists(Lists.newArrayList((Object[])new Formula[]{var_C}), and_cEq2_bMinusCgt1000);
        BooleanFormula result = this.qmgr.eliminateQuantifiers(f);
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"exists");
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"c");
        BooleanFormula expected = this.imgr.greaterOrEquals(var_B, this.imgr.makeNumber(1003L));
        this.assertThatFormula(result).isEquivalentTo(expected);
    }

    @Test
    @Ignore
    public void quantifierEliminationTest2() throws Exception {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula i1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i@1");
        NumeralFormula.IntegerFormula j1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@1");
        NumeralFormula.IntegerFormula j2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@2");
        NumeralFormula.IntegerFormula a1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a@1");
        NumeralFormula.IntegerFormula _1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula _minus1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-1L);
        NumeralFormula.IntegerFormula _1_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(_1, a1);
        BooleanFormula not_j1_eq_minus1 = this.bmgr.not(this.imgr.equal(j1, _minus1));
        BooleanFormula i1_eq_1_plus_a1 = this.imgr.equal(i1, _1_plus_a1);
        NumeralFormula.IntegerFormula j2_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(j2, a1);
        BooleanFormula j1_eq_j2_plus_a1 = this.imgr.equal(j1, j2_plus_a1);
        BooleanFormula fm = this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{i1_eq_1_plus_a1, not_j1_eq_minus1, j1_eq_j2_plus_a1}));
        BooleanFormula q = this.qmgr.exists(Lists.newArrayList((Object[])new Formula[]{j1}), fm);
        BooleanFormula result = this.qmgr.eliminateQuantifiers(q);
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"exists");
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"j@1");
        BooleanFormula expected = this.bmgr.not(this.imgr.equal(i1, j2));
        this.assertThatFormula(result).isEquivalentTo(expected);
    }

    @Test
    public void testGetFormulaType() {
        BooleanFormula _boolVar = this.bmgr.makeVariable("boolVar");
        Truth.assertThat(this.mgr.getFormulaType(_boolVar)).isEqualTo(FormulaType.BooleanType);
        NumeralFormula.IntegerFormula _intVar = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        Truth.assertThat(this.mgr.getFormulaType(_intVar)).isEqualTo(FormulaType.IntegerType);
        this.requireArrays();
        ArrayFormula _arrayVar = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        Truth.assertThat(this.mgr.getFormulaType(_arrayVar)).isInstanceOf(FormulaType.ArrayFormulaType.class);
    }

    @Test
    public void testMakeIntArray() {
        this.requireArrays();
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula _1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula _i_plus_1 = (NumeralFormula.IntegerFormula)this.imgr.add(_i, _1);
        ArrayFormula _b = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        NumeralFormula.IntegerFormula _b_at_i_plus_1 = (NumeralFormula.IntegerFormula)this.amgr.select(_b, _i_plus_1);
        if (this.solver == SolverContextFactory.Solvers.MATHSAT5) {
            Truth.assertThat((String)_b_at_i_plus_1.toString()).isEqualTo((Object)"(`read_int_int` b (`+_int` i 1))");
        } else if (this.solver == SolverContextFactory.Solvers.PRINCESS) {
            Truth.assertThat((String)_b_at_i_plus_1.toString()).isEqualTo((Object)"select(b, (i + 1))");
        } else {
            Truth.assertThat((String)_b_at_i_plus_1.toString()).isEqualTo((Object)"(select b (+ i 1))");
        }
    }

    @Test
    public void testMakeBitVectorArray() {
        this.requireArrays();
        this.requireBitvectors();
        BitvectorFormula _i = this.mgr.getBitvectorFormulaManager().makeVariable(64, "i");
        ArrayFormula _b = this.amgr.makeArray("b", FormulaType.getBitvectorTypeWithSize(64), FormulaType.getBitvectorTypeWithSize(32));
        BitvectorFormula _b_at_i = (BitvectorFormula)this.amgr.select(_b, _i);
        if (this.solver == SolverContextFactory.Solvers.MATHSAT5) {
            Truth.assertThat((String)_b_at_i.toString()).isEqualTo((Object)"(`read_<BitVec, 64, >_<BitVec, 32, >` b i)");
        } else {
            Truth.assertThat((String)_b_at_i.toString()).isEqualTo((Object)"(select b i)");
        }
    }

    @Test
    public void testNestedRationalArray() {
        this.requireArrays();
        this.requireRationals();
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        ArrayFormula multi = this.amgr.makeArray("multi", FormulaType.NumeralType.IntegerType, FormulaType.getArrayType(FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.RationalType));
        NumeralFormula.RationalFormula valueInMulti = (NumeralFormula.RationalFormula)this.amgr.select((ArrayFormula)this.amgr.select(multi, _i), _i);
        if (this.solver == SolverContextFactory.Solvers.MATHSAT5) {
            Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(`read_int_rat` (`read_int_<Array, Int, Real, >` multi i) i)");
        } else {
            Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(select (select multi i) i)");
        }
    }

    @Test
    public void testNestedBitVectorArray() {
        this.requireArrays();
        this.requireBitvectors();
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        ArrayFormula multi = this.amgr.makeArray("multi", FormulaType.NumeralType.IntegerType, FormulaType.getArrayType(FormulaType.NumeralType.IntegerType, FormulaType.getBitvectorTypeWithSize(32)));
        BitvectorFormula valueInMulti = (BitvectorFormula)this.amgr.select((ArrayFormula)this.amgr.select(multi, _i), _i);
        if (this.solver == SolverContextFactory.Solvers.MATHSAT5) {
            Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(`read_int_<BitVec, 32, >` (`read_int_<Array, Int, <BitVec, 32, >, >` multi i) i)");
        } else {
            Truth.assertThat((String)valueInMulti.toString()).isEqualTo((Object)"(select (select multi i) i)");
        }
    }

    @Test
    public void nonLinearMultiplication() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula x_mult_y;
        NumeralFormula.IntegerFormula i2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula i3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula i4 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
        try {
            x_mult_y = (NumeralFormula.IntegerFormula)this.imgr.multiply(x, y);
        }
        catch (UnsupportedOperationException e) {
            this.requireFalse("Support for non-linear arithmetic is optional");
            return;
        }
        BooleanFormula x_equal_2 = this.imgr.equal(i2, x);
        BooleanFormula y_equal_3 = this.imgr.equal(i3, y);
        BooleanFormula z_equal_4 = this.imgr.equal(i4, z);
        BooleanFormula z_equal_x_mult_y = this.imgr.equal(z, x_mult_y);
        try (ProverEnvironment env = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            env.push(x_equal_2);
            env.push(y_equal_3);
            env.push(z_equal_4);
            env.push(z_equal_x_mult_y);
            this.assertThatEnvironment(env).isUnsatisfiable();
        }
    }

    @Test
    public void nonLinearDivision() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula x_div_y;
        NumeralFormula.IntegerFormula i2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula i3 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula i4 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
        try {
            x_div_y = (NumeralFormula.IntegerFormula)this.imgr.divide(x, y);
        }
        catch (UnsupportedOperationException e) {
            this.requireFalse("Support for non-linear arithmetic is optional");
            return;
        }
        BooleanFormula x_equal_4 = this.imgr.equal(i4, x);
        BooleanFormula y_equal_2 = this.imgr.equal(i2, y);
        BooleanFormula z_equal_3 = this.imgr.equal(i3, z);
        BooleanFormula z_equal_x_div_y = this.imgr.equal(z, x_div_y);
        try (ProverEnvironment env = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            env.push(x_equal_4);
            env.push(y_equal_2);
            env.push(z_equal_3);
            env.push(z_equal_x_div_y);
            this.assertThatEnvironment(env).isUnsatisfiable();
        }
    }
}

