/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.NumeralFormulaManager;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverStackTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public boolean useInterpolatingEnvironment;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0} (interpolation={1}}")
    public static List<Object[]> getAllCombinations() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            result.add(new Object[]{solver, false});
            result.add(new Object[]{solver, true});
        }
        return result;
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    private BasicProverEnvironment<?> newEnvironmentForTest(SolverContext.ProverOptions ... options) {
        if (this.useInterpolatingEnvironment) {
            this.requireInterpolation();
            return this.context.newProverEnvironmentWithInterpolation();
        }
        return this.context.newProverEnvironment(options);
    }

    private void requireMultipleStackSupport() {
        TruthJUnit.assume().withFailureMessage("Solver does not support multiple stacks yet").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.SMTINTERPOL);
    }

    protected final void requireUfValuesInModel() {
        TruthJUnit.assume().withFailureMessage("Integration of solver does not support retrieving values for UFs from a model").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
    }

    @Test
    public void simpleStackTestBool() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        int i = index.getFreshId();
        BooleanFormula a = this.bmgr.makeVariable("bool_a" + i);
        BooleanFormula b = this.bmgr.makeVariable("bool_b" + i);
        BooleanFormula or = this.bmgr.or(a, b);
        stack.push(or);
        this.assertThatEnvironment(stack).isSatisfiable();
        BooleanFormula c = this.bmgr.makeVariable("bool_c" + i);
        BooleanFormula d = this.bmgr.makeVariable("bool_d" + i);
        BooleanFormula and = this.bmgr.and(c, d);
        stack.push(and);
        this.assertThatEnvironment(stack).isSatisfiable();
        BooleanFormula notOr = this.bmgr.not(or);
        stack.push(notOr);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.push(and);
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.push(notOr);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
    }

    @Test
    public void singleStackTestInteger() throws Exception {
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        this.simpleStackTestNum(this.imgr, env);
    }

    @Test
    public void singleStackTestRational() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        this.simpleStackTestNum(this.rmgr, env);
    }

    private <X extends NumeralFormula, Y extends X> void simpleStackTestNum(NumeralFormulaManager<X, Y> nmgr, BasicProverEnvironment<?> stack) throws Exception {
        int i = index.getFreshId();
        Y a = nmgr.makeVariable("num_a" + i);
        Y b = nmgr.makeVariable("num_b" + i);
        BooleanFormula leqAB = nmgr.lessOrEquals(a, b);
        stack.push(leqAB);
        this.assertThatEnvironment(stack).isSatisfiable();
        Y c = nmgr.makeVariable("num_c" + i);
        Y d = nmgr.makeVariable("num_d" + i);
        BooleanFormula eqCD = nmgr.lessOrEquals(c, d);
        stack.push(eqCD);
        this.assertThatEnvironment(stack).isSatisfiable();
        BooleanFormula gtAB = nmgr.greaterThan(a, b);
        stack.push(gtAB);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.push(eqCD);
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.push(gtAB);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        stack.pop();
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
    }

    @Test
    public void stackTest() {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        this.thrown.expect(RuntimeException.class);
        stack.pop();
    }

    @Test
    public void dualStackTest() throws Exception {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        stack1.push(a);
        stack1.push(a);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        stack1.pop();
        stack1.pop();
        stack1.push(a);
        this.assertThatEnvironment(stack1).isSatisfiable();
        stack2.push(not);
        this.assertThatEnvironment(stack2).isSatisfiable();
        stack1.pop();
        stack2.pop();
    }

    @Test
    public void dualStackTest2() throws Exception {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        stack1.push(a);
        stack1.push(this.bmgr.makeBoolean(true));
        this.assertThatEnvironment(stack1).isSatisfiable();
        stack2.push(not);
        this.assertThatEnvironment(stack2).isSatisfiable();
        stack1.pop();
        this.assertThatEnvironment(stack1).isSatisfiable();
        stack1.pop();
        this.assertThatEnvironment(stack1).isSatisfiable();
        stack2.pop();
        this.assertThatEnvironment(stack2).isSatisfiable();
        this.assertThatEnvironment(stack1).isSatisfiable();
    }

    @Test
    public void dualStackGlobalDeclarations() throws Exception {
        this.requireMultipleStackSupport();
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        stack1.push(this.bmgr.makeVariable("bool_a"));
        String varName = "bool_b";
        BooleanFormula b = this.bmgr.makeVariable("bool_b");
        stack1.push(b);
        this.assertThatEnvironment(stack1).isSatisfiable();
        stack1.pop();
        stack1.pop();
        stack1.close();
        this.assertThatFormula(b).isEquivalentTo(this.bmgr.makeVariable("bool_b"));
    }

    @Test
    public void modelForUnsatFormula() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            stack.push(this.imgr.greaterThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(0L)));
            this.assertThatEnvironment(stack).isUnsatisfiable();
            this.thrown.expect(Exception.class);
            stack.getModel();
        }
    }

    @Test
    public void modelForSatFormula() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            stack.push(this.imgr.greaterThan(a, this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan(a, this.imgr.makeNumber(2L)));
            this.assertThatEnvironment(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(a)).isEqualTo((Object)BigInteger.ONE);
        }
    }

    @Test
    public void modelForSatFormulaWithLargeValue() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_MODELS);){
            BigInteger val = BigInteger.TEN.pow(1000);
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            stack.push(this.imgr.equal(a, this.imgr.makeNumber(val)));
            this.assertThatEnvironment(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(a)).isEqualTo((Object)val);
        }
    }

    @Test
    public void modelForSatFormulaWithUF() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
            NumeralFormula.IntegerFormula varA = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            NumeralFormula.IntegerFormula varB = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
            stack.push(this.imgr.equal(varA, zero));
            stack.push(this.imgr.equal(varB, zero));
            FunctionDeclaration<NumeralFormula.IntegerFormula> uf = this.fmgr.declareUF("uf", FormulaType.IntegerType, FormulaType.IntegerType);
            stack.push(this.imgr.equal((NumeralFormula)this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of((Object)varA)), zero));
            stack.push(this.imgr.equal((NumeralFormula)this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of((Object)varB)), zero));
            this.assertThatEnvironment(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(varA)).isEqualTo((Object)BigInteger.ZERO);
            Truth.assertThat((Comparable)model.evaluate(varB)).isEqualTo((Object)BigInteger.ZERO);
            this.requireUfValuesInModel();
            Truth.assertThat((Comparable)model.evaluate(this.fmgr.callUF(uf, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(BigDecimal.ZERO))))).isEqualTo((Object)BigInteger.ZERO);
        }
    }
}

